/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import org.simpleflatmapper.datastax.DataHelper;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.primitive.LongGetter;

public class DatastaxGenericLongGetter
implements LongGetter<GettableByIndexData>,
Getter<GettableByIndexData, Long> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericLongGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        if (DataTypeHelper.isNumber(name)) {
            return name;
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Long get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return this.getLong(target);
    }

    public long getLong(GettableByIndexData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).longValue();
            }
            case INT: {
                return target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).longValue();
            }
            case FLOAT: {
                return (long)target.getFloat(this.index);
            }
            case DOUBLE: {
                return (long)target.getDouble(this.index);
            }
        }
        if (DataTypeHelper.isSmallInt(this.dataTypeName)) {
            return DataHelper.getShort(this.index, target);
        }
        if (DataTypeHelper.isTinyInt(this.dataTypeName)) {
            return DataHelper.getByte(this.index, target);
        }
        if (DataTypeHelper.isTime(this.dataTypeName)) {
            return DataHelper.getTime(this.index, target);
        }
        return 0L;
    }
}

