/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.simpleflatmapper.datastax.BoundStatementMapper;
import org.simpleflatmapper.datastax.DatastaxMapper;
import org.simpleflatmapper.datastax.UninterruptibleFuture;

public class DatastaxCrud<T, K> {
    private final PreparedStatement readQuery;
    private final PreparedStatement deleteQuery;
    private final PreparedStatement deleteQueryWithTimestamp;
    private final PreparedStatement insertQuery;
    private final PreparedStatement insertQueryWithTtlAndTimestamp;
    private final PreparedStatement insertQueryWithTtl;
    private final PreparedStatement insertQueryWithTimestamp;
    private final BoundStatementMapper<K> keySetter;
    private final BoundStatementMapper<K> keySetterWith1Option;
    private final BoundStatementMapper<T> insertSetter;
    private final DatastaxMapper<T> selectMapper;
    private final int numberOfColumns;
    private final Session session;

    public DatastaxCrud(PreparedStatement insertQuery, PreparedStatement insertQueryWithTtlAndTimestamp, PreparedStatement insertQueryWithTtl, PreparedStatement insertQueryWithTimestamp, PreparedStatement readQuery, PreparedStatement deleteQuery, PreparedStatement deleteQueryWithTimestamp, BoundStatementMapper<T> insertSetter, BoundStatementMapper<K> keySetter, BoundStatementMapper<K> keySetterWith1Option, DatastaxMapper<T> selectMapper, int numberOfColumns, Session session) {
        this.readQuery = readQuery;
        this.deleteQuery = deleteQuery;
        this.insertQuery = insertQuery;
        this.insertQueryWithTtlAndTimestamp = insertQueryWithTtlAndTimestamp;
        this.insertQueryWithTtl = insertQueryWithTtl;
        this.insertQueryWithTimestamp = insertQueryWithTimestamp;
        this.deleteQueryWithTimestamp = deleteQueryWithTimestamp;
        this.keySetter = keySetter;
        this.insertSetter = insertSetter;
        this.keySetterWith1Option = keySetterWith1Option;
        this.selectMapper = selectMapper;
        this.numberOfColumns = numberOfColumns;
        this.session = session;
    }

    public void save(T value) {
        this.saveAsync(value).getUninterruptibly();
    }

    public void save(T value, int ttl, long timestamp) {
        this.saveAsync(value, ttl, timestamp).getUninterruptibly();
    }

    public void saveWithTtl(T value, int ttl) {
        this.saveWithTtlAsync(value, ttl).getUninterruptibly();
    }

    public void saveWithTimestamp(T value, long timestamp) {
        this.saveWithTimestampAsync(value, timestamp).getUninterruptibly();
    }

    public UninterruptibleFuture<Void> saveAsync(T value) {
        BoundStatement boundStatement = this.saveQuery(value);
        return new NoResultFuture(this.session.executeAsync((Statement)boundStatement));
    }

    public UninterruptibleFuture<Void> saveAsync(T value, int ttl, long timestamp) {
        BoundStatement boundStatement = this.saveQuery(value, ttl, timestamp);
        return new NoResultFuture(this.session.executeAsync((Statement)boundStatement));
    }

    public UninterruptibleFuture<Void> saveWithTtlAsync(T value, int ttl) {
        BoundStatement boundStatement = this.saveQueryWithTtl(value, ttl);
        return new NoResultFuture(this.session.executeAsync((Statement)boundStatement));
    }

    public UninterruptibleFuture<Void> saveWithTimestampAsync(T value, long timestamp) {
        BoundStatement boundStatement = this.saveQueryWithTimestamp(value, timestamp);
        return new NoResultFuture(this.session.executeAsync((Statement)boundStatement));
    }

    public BoundStatement saveQuery(T value) {
        return this.insertSetter.mapTo(value, this.insertQuery.bind());
    }

    public BoundStatement saveQuery(T value, int ttl, long timestamp) {
        BoundStatement boundStatement = this.insertQueryWithTtlAndTimestamp.bind();
        this.insertSetter.mapTo(value, boundStatement);
        boundStatement.setInt(this.numberOfColumns, ttl);
        boundStatement.setLong(this.numberOfColumns + 1, timestamp);
        return boundStatement;
    }

    public BoundStatement saveQueryWithTtl(T value, int ttl) {
        BoundStatement boundStatement = this.insertQueryWithTtl.bind();
        this.insertSetter.mapTo(value, boundStatement);
        boundStatement.setInt(this.numberOfColumns, ttl);
        return boundStatement;
    }

    public BoundStatement saveQueryWithTimestamp(T value, long timestamp) {
        BoundStatement boundStatement = this.insertQueryWithTimestamp.bind();
        this.insertSetter.mapTo(value, boundStatement);
        boundStatement.setLong(this.numberOfColumns, timestamp);
        return boundStatement;
    }

    public T read(K key) {
        return this.readAsync(key).getUninterruptibly();
    }

    public UninterruptibleFuture<T> readAsync(K key) {
        BoundStatement boundStatement = this.keySetter.mapTo(key, this.readQuery.bind());
        return new OneResultFuture<T>(this.session.executeAsync((Statement)boundStatement), this.selectMapper);
    }

    public void delete(K key) {
        this.deleteAsync(key).getUninterruptibly();
    }

    public void delete(K key, long timestamp) {
        this.deleteAsync(key, timestamp).getUninterruptibly();
    }

    public UninterruptibleFuture<Void> deleteAsync(K key, long timestamp) {
        BoundStatement boundStatement = this.deleteQuery(key, timestamp);
        ResultSetFuture resultSetFuture = this.session.executeAsync((Statement)boundStatement);
        return new NoResultFuture(resultSetFuture);
    }

    public UninterruptibleFuture<Void> deleteAsync(K key) {
        BoundStatement boundStatement = this.deleteQuery(key);
        ResultSetFuture resultSetFuture = this.session.executeAsync((Statement)boundStatement);
        return new NoResultFuture(resultSetFuture);
    }

    public BoundStatement deleteQuery(K key) {
        return this.keySetter.mapTo(key, this.deleteQuery.bind());
    }

    public BoundStatement deleteQuery(K key, long timestamp) {
        BoundStatement boundStatement = this.deleteQueryWithTimestamp.bind();
        boundStatement.setLong(0, timestamp);
        return this.keySetterWith1Option.mapTo(key, boundStatement);
    }

    private class NoResultFuture
    implements UninterruptibleFuture<Void> {
        private final ResultSetFuture resultSetFuture;

        public NoResultFuture(ResultSetFuture resultSetFuture) {
            this.resultSetFuture = resultSetFuture;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.resultSetFuture.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.resultSetFuture.isCancelled();
        }

        public boolean isDone() {
            return this.resultSetFuture.isDone();
        }

        public Void get() throws InterruptedException, ExecutionException {
            this.resultSetFuture.get();
            return null;
        }

        @Override
        public Void getUninterruptibly() {
            this.resultSetFuture.getUninterruptibly();
            return null;
        }

        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.resultSetFuture.get(timeout, unit);
            return null;
        }

        public void addListener(Runnable listener, Executor executor) {
            this.resultSetFuture.addListener(listener, executor);
        }
    }

    private class OneResultFuture<T>
    implements UninterruptibleFuture<T> {
        private final ResultSetFuture resultSetFuture;
        private final DatastaxMapper<T> mapper;

        public OneResultFuture(ResultSetFuture resultSetFuture, DatastaxMapper<T> mapper) {
            this.resultSetFuture = resultSetFuture;
            this.mapper = mapper;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.resultSetFuture.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.resultSetFuture.isCancelled();
        }

        public boolean isDone() {
            return this.resultSetFuture.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            ResultSet rs = (ResultSet)this.resultSetFuture.get();
            return this.mapOneSelect(rs);
        }

        @Override
        public T getUninterruptibly() {
            ResultSet rs = this.resultSetFuture.getUninterruptibly();
            return this.mapOneSelect(rs);
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ResultSet rs = (ResultSet)this.resultSetFuture.get(timeout, unit);
            return this.mapOneSelect(rs);
        }

        private T mapOneSelect(ResultSet rs) {
            Row row = rs.one();
            if (row != null) {
                return (T)this.mapper.map(row);
            }
            return null;
        }

        public void addListener(Runnable listener, Executor executor) {
            this.resultSetFuture.addListener(listener, executor);
        }
    }
}

