/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.impl.setter.BigDecimalSettableDataSetter;
import org.sfm.datastax.impl.setter.BigIntegerSettableDataSetter;
import org.sfm.datastax.impl.setter.ConverterToTupleValueMapper;
import org.sfm.datastax.impl.setter.ConverterToUDTValueMapper;
import org.sfm.datastax.impl.setter.DateSettableDataSetter;
import org.sfm.datastax.impl.setter.DoubleSettableDataSetter;
import org.sfm.datastax.impl.setter.FloatSettableDataSetter;
import org.sfm.datastax.impl.setter.InetAddressSettableDataSetter;
import org.sfm.datastax.impl.setter.IntSettableDataSetter;
import org.sfm.datastax.impl.setter.ListSettableDataSetter;
import org.sfm.datastax.impl.setter.ListWithConverterSettableDataSetter;
import org.sfm.datastax.impl.setter.LongSettableDataSetter;
import org.sfm.datastax.impl.setter.MapSettableDataSetter;
import org.sfm.datastax.impl.setter.MapWithConverterSettableDataSetter;
import org.sfm.datastax.impl.setter.OrdinalEnumSettableDataSetter;
import org.sfm.datastax.impl.setter.SetSettableDataSetter;
import org.sfm.datastax.impl.setter.SetWithConverterSettableDataSetter;
import org.sfm.datastax.impl.setter.StringEnumSettableDataSetter;
import org.sfm.datastax.impl.setter.StringSettableDataSetter;
import org.sfm.datastax.impl.setter.TupleSettableDataSetter;
import org.sfm.datastax.impl.setter.TupleValueSettableDataSetter;
import org.sfm.datastax.impl.setter.UDTObjectSettableDataSetter;
import org.sfm.datastax.impl.setter.UDTValueSettableDataSetter;
import org.sfm.datastax.impl.setter.UUIDSettableDataSetter;
import org.sfm.jdbc.impl.convert.joda.JodaDateTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.joda.JodaInstantTojuDateConverter;
import org.sfm.jdbc.impl.convert.joda.JodaLocalDateTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.joda.JodaLocalDateTojuDateConverter;
import org.sfm.jdbc.impl.convert.joda.JodaLocalTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaInstantTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaLocalDateTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaLocalDateTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaLocalTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaOffsetDateTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaOffsetTimeTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaYearMonthTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaYearTojuDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaZonedDateTimeTojuDateConverter;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.column.joda.JodaHelper;
import org.sfm.map.column.time.JavaTimeHelper;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.setter.ConvertDelegateSetter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.TypeHelper;
import org.sfm.tuples.Tuple2;
import org.sfm.tuples.Tuples;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.ConverterFactory;

public class SettableDataSetterFactory
implements SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>> {
    private final Map<Class<?>, SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>> factoryPerClass = new HashMap();
    private final MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> mapperConfig;
    private final ReflectionService reflectionService;
    private final SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>> jodaTimeFieldMapperToSourceFactory;
    private final SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>> javaTimeFieldMapperToSourceFactory;

    public SettableDataSetterFactory(MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> mapperConfig, ReflectionService reflectionService) {
        this.factoryPerClass.put(Integer.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new IntSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Integer.class, this.factoryPerClass.get(Integer.TYPE));
        this.factoryPerClass.put(Long.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new LongSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Long.class, this.factoryPerClass.get(Long.TYPE));
        this.factoryPerClass.put(Float.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new FloatSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Float.class, this.factoryPerClass.get(Float.TYPE));
        this.factoryPerClass.put(Double.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new DoubleSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Double.class, this.factoryPerClass.get(Double.TYPE));
        this.factoryPerClass.put(String.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new StringSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Date.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new DateSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(UUID.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new UUIDSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(BigDecimal.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new BigDecimalSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(BigInteger.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new BigIntegerSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(InetAddress.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new InetAddressSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(TupleValue.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new TupleValueSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.jodaTimeFieldMapperToSourceFactory = new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> pm) {
                DateSettableDataSetter setter = new DateSettableDataSetter(((DatastaxColumnKey)pm.getColumnKey()).getIndex());
                Type propertyType = pm.getPropertyMeta().getPropertyType();
                JodaLocalDateTimeTojuDateConverter converter = null;
                DateTimeZone dateTimeZone = JodaHelper.getDateTimeZoneOrDefault((ColumnDefinition)pm.getColumnDefinition());
                if (JodaTimeClasses.isJodaLocalDateTime((Type)propertyType)) {
                    converter = new JodaLocalDateTimeTojuDateConverter(dateTimeZone);
                } else if (JodaTimeClasses.isJodaLocalDate((Type)propertyType)) {
                    converter = new JodaLocalDateTojuDateConverter();
                } else if (JodaTimeClasses.isJodaDateTime((Type)propertyType)) {
                    converter = new JodaDateTimeTojuDateConverter();
                } else if (JodaTimeClasses.isJodaInstant((Type)propertyType)) {
                    converter = new JodaInstantTojuDateConverter();
                } else if (JodaTimeClasses.isJodaLocalTime((Type)propertyType)) {
                    converter = new JodaLocalTimeTojuDateConverter(dateTimeZone);
                }
                if (converter != null) {
                    return new ConvertDelegateSetter((Setter)setter, (Converter)converter);
                }
                return null;
            }
        };
        this.javaTimeFieldMapperToSourceFactory = new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> pm) {
                DateSettableDataSetter setter = new DateSettableDataSetter(((DatastaxColumnKey)pm.getColumnKey()).getIndex());
                Type propertyType = pm.getPropertyMeta().getPropertyType();
                JavaLocalDateTimeTojuDateConverter converter = null;
                ZoneId dateTimeZone = JavaTimeHelper.getZoneIdOrDefault((ColumnDefinition)pm.getColumnDefinition());
                if (TypeHelper.areEquals((Type)propertyType, LocalDateTime.class)) {
                    converter = new JavaLocalDateTimeTojuDateConverter(dateTimeZone);
                } else if (TypeHelper.areEquals((Type)propertyType, LocalDate.class)) {
                    converter = new JavaLocalDateTojuDateConverter(dateTimeZone);
                } else if (TypeHelper.areEquals((Type)propertyType, ZonedDateTime.class)) {
                    converter = new JavaZonedDateTimeTojuDateConverter();
                } else if (TypeHelper.areEquals((Type)propertyType, Instant.class)) {
                    converter = new JavaInstantTojuDateConverter();
                } else if (TypeHelper.areEquals((Type)propertyType, LocalTime.class)) {
                    converter = new JavaLocalTimeTojuDateConverter(dateTimeZone);
                } else if (TypeHelper.areEquals((Type)propertyType, OffsetDateTime.class)) {
                    converter = new JavaOffsetDateTimeTojuDateConverter();
                } else if (TypeHelper.areEquals((Type)propertyType, OffsetTime.class)) {
                    converter = new JavaOffsetTimeTojuDateConverter();
                } else if (TypeHelper.areEquals((Type)propertyType, Year.class)) {
                    converter = new JavaYearTojuDateConverter(dateTimeZone);
                } else if (TypeHelper.areEquals((Type)propertyType, YearMonth.class)) {
                    converter = new JavaYearMonthTojuDateConverter(dateTimeZone);
                }
                if (converter != null) {
                    return new ConvertDelegateSetter((Setter)setter, (Converter)converter);
                }
                return null;
            }
        };
        this.mapperConfig = mapperConfig;
        this.reflectionService = reflectionService;
    }

    public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
        Object setter = null;
        Type propertyType = arg.getPropertyMeta().getPropertyType();
        Type type = ((DatastaxColumnKey)arg.getColumnKey()).getDataType().asJavaClass();
        if (type == null) {
            type = propertyType;
        }
        if (TypeHelper.isEnum((Type)propertyType)) {
            if (TypeHelper.isClass((Type)type, String.class)) {
                return new StringEnumSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
            return new OrdinalEnumSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
        }
        SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>> setterFactory = this.factoryPerClass.get(TypeHelper.toClass((Type)type));
        if (setterFactory != null) {
            setter = setterFactory.getSetter(arg);
            if (!TypeHelper.areEquals((Type)TypeHelper.toBoxedClass((Type)type), (Class)TypeHelper.toBoxedClass((Type)propertyType))) {
                Converter<?, ?> converter = this.getConverter(propertyType, TypeHelper.toClass((Type)type), ((DatastaxColumnKey)arg.getColumnKey()).getDataType());
                setter = converter != null ? new Setter(setter, converter) : null;
            }
        }
        if (setter == null) {
            DataType dataTypeElt;
            if (Tuples.isTuple((Type)propertyType) && TypeHelper.areEquals((Type)type, TupleValue.class)) {
                setter = TupleSettableDataSetter.newInstance(propertyType, (TupleType)((DatastaxColumnKey)arg.getColumnKey()).getDataType(), ((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.mapperConfig, this.reflectionService);
            } else if (((DatastaxColumnKey)arg.getColumnKey()).getDataType() instanceof UserType) {
                setter = propertyType.equals(UDTValue.class) ? new UDTValueSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex()) : UDTObjectSettableDataSetter.newInstance(propertyType, (UserType)((DatastaxColumnKey)arg.getColumnKey()).getDataType(), ((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.mapperConfig, this.reflectionService);
            } else if (TypeHelper.isAssignable(List.class, (Type)type) && TypeHelper.isAssignable(List.class, (Type)propertyType)) {
                dataTypeElt = (DataType)((DatastaxColumnKey)arg.getColumnKey()).getDataType().getTypeArguments().get(0);
                Class dEltType = dataTypeElt.asJavaClass();
                Type lEltType = TypeHelper.getComponentTypeOfListOrArray((Type)propertyType);
                if (TypeHelper.areEquals((Type)lEltType, (Class)dEltType)) {
                    setter = new ListSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                } else {
                    Converter<?, ?> converter = this.getConverter(lEltType, dEltType, dataTypeElt);
                    if (converter != null) {
                        setter = new ListWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), converter);
                    }
                }
            } else if (TypeHelper.isAssignable(Set.class, (Type)type) && TypeHelper.isAssignable(Set.class, (Type)propertyType)) {
                dataTypeElt = (DataType)((DatastaxColumnKey)arg.getColumnKey()).getDataType().getTypeArguments().get(0);
                Class dEltType = dataTypeElt.asJavaClass();
                Type lEltType = TypeHelper.getComponentTypeOfListOrArray((Type)propertyType);
                if (TypeHelper.areEquals((Type)lEltType, (Class)dEltType)) {
                    setter = new SetSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                } else {
                    Converter<?, ?> converter = this.getConverter(lEltType, dEltType, dataTypeElt);
                    if (converter != null) {
                        setter = new SetWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), converter);
                    }
                }
            } else if (TypeHelper.isAssignable(Map.class, (Type)type) && TypeHelper.isAssignable(Map.class, (Type)propertyType)) {
                DataType dtKeyType = (DataType)((DatastaxColumnKey)arg.getColumnKey()).getDataType().getTypeArguments().get(0);
                DataType dtValueType = (DataType)((DatastaxColumnKey)arg.getColumnKey()).getDataType().getTypeArguments().get(1);
                Tuple2 keyValueTypeOfMap = TypeHelper.getKeyValueTypeOfMap((Type)propertyType);
                setter = this.areSame(dtKeyType, (Type)keyValueTypeOfMap.getElement0()) && this.areSame(dtValueType, (Type)keyValueTypeOfMap.getElement1()) ? new MapSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex()) : new MapWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.getConverter((Type)keyValueTypeOfMap.getElement0(), dtKeyType.asJavaClass(), dtKeyType), this.getConverter((Type)keyValueTypeOfMap.getElement1(), dtValueType.asJavaClass(), dtValueType));
            }
        }
        if (setter == null) {
            setter = this.jodaTimeFieldMapperToSourceFactory.getSetter(arg);
        }
        if (setter == null) {
            setter = this.javaTimeFieldMapperToSourceFactory.getSetter(arg);
        }
        return setter;
    }

    private boolean areSame(DataType dtKeyType, Type element0) {
        return TypeHelper.areEquals((Type)element0, (Class)dtKeyType.asJavaClass());
    }

    private Converter<?, ?> getConverter(Type elementType, Class<?> dataTypeElt, DataType dtElt) {
        if (dtElt != null) {
            if (UDTValue.class.equals(dataTypeElt)) {
                Mapper mapper = UDTObjectSettableDataSetter.newUDTMapper(elementType, (UserType)dtElt, this.mapperConfig, this.reflectionService);
                return new ConverterToUDTValueMapper(mapper, (UserType)dtElt);
            }
            if (TupleValue.class.equals(dataTypeElt)) {
                Mapper mapper = TupleSettableDataSetter.newTupleMapper(elementType, (TupleType)dtElt, this.mapperConfig, this.reflectionService);
                return new ConverterToTupleValueMapper(mapper, (TupleType)dtElt);
            }
        }
        return ConverterFactory.getConverter((Class)TypeHelper.toClass((Type)elementType), dataTypeElt);
    }
}

