/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.TupleType;
import java.lang.reflect.Type;
import java.util.List;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxMapperFactory;
import org.sfm.datastax.impl.getter.DatastaxUDTGetter;
import org.sfm.map.FieldKey;
import org.sfm.map.Mapper;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.FieldMapperMapperBuilder;
import org.sfm.reflect.Getter;
import org.sfm.tuples.Tuple2;

public class DatastaxTupleGetter<T extends Tuple2<?, ?>>
implements Getter<GettableByIndexData, T> {
    private final Mapper<GettableByIndexData, T> mapper;
    private final int index;

    public DatastaxTupleGetter(Mapper<GettableByIndexData, T> mapper, int index) {
        this.mapper = mapper;
        this.index = index;
    }

    public T get(GettableByIndexData target) throws Exception {
        return (T)((Tuple2)this.mapper.map((Object)target.getTupleValue(this.index)));
    }

    public static <P extends Tuple2<?, ?>> Getter<GettableByIndexData, P> newInstance(DatastaxMapperFactory factory, Type target, TupleType tt, int index) {
        Mapper<GettableByIndexData, P> mapper = DatastaxTupleGetter.newTupleMapper(target, tt, factory);
        return new DatastaxTupleGetter<P>(mapper, index);
    }

    public static <P extends Tuple2<?, ?>> Mapper<GettableByIndexData, P> newTupleMapper(Type target, TupleType tt, DatastaxMapperFactory factory) {
        FieldMapperMapperBuilder builder = DatastaxUDTGetter.newFieldMapperBuilder(factory, target);
        List componentTypes = tt.getComponentTypes();
        for (int i = 0; i < componentTypes.size(); ++i) {
            FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
            builder.addMapping((FieldKey)new DatastaxColumnKey("elt" + i, i, (DataType)componentTypes.get(i)), identity);
        }
        return builder.mapper();
    }
}

