/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.lang.reflect.Type;
import java.util.List;
import org.sfm.datastax.BoundStatementMapper;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxCrud;
import org.sfm.datastax.DatastaxMapper;
import org.sfm.datastax.DatastaxMapperBuilder;
import org.sfm.datastax.DatastaxMapperFactory;
import org.sfm.datastax.SettableDataMapperBuilder;
import org.sfm.map.column.ColumnProperty;

public class DatastaxCrudFactory {
    public static <T, K> DatastaxCrud<T, K> newInstance(Type target, Type keyTarget, TableMetadata tableMetadata, Session session, DatastaxMapperFactory datastaxMapperFactory) {
        DatastaxMapperFactory mapperFactory = DatastaxMapperFactory.newInstance(datastaxMapperFactory);
        return DatastaxCrudFactory.createCrud(target, keyTarget, tableMetadata, session, mapperFactory);
    }

    private static <T, K> DatastaxCrud<T, K> createCrud(Type target, Type keyTarget, TableMetadata tableMetadata, Session session, DatastaxMapperFactory mapperFactory) {
        BoundStatementMapper<T> insertSetter = DatastaxCrudFactory.insertSetter(target, tableMetadata, mapperFactory);
        BoundStatementMapper<K> keySetter = DatastaxCrudFactory.keySetter(keyTarget, tableMetadata, mapperFactory);
        DatastaxMapper<T> selectMapper = DatastaxCrudFactory.selectMapper(target, tableMetadata, mapperFactory);
        return new DatastaxCrud<T, K>(session.prepare(DatastaxCrudFactory.insertQuery(tableMetadata)), session.prepare(DatastaxCrudFactory.readQuery(tableMetadata)), session.prepare(DatastaxCrudFactory.deleteQuery(tableMetadata)), insertSetter, keySetter, selectMapper);
    }

    private static String deleteQuery(TableMetadata tableMetadata) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(tableMetadata.getName());
        sb.append(" WHERE ");
        List columns = tableMetadata.getPrimaryKey();
        boolean first = true;
        for (ColumnMetadata column : columns) {
            if (!first) {
                sb.append(" and ");
            }
            sb.append(column.getName()).append(" = ?");
            first = false;
        }
        return sb.toString();
    }

    private static String readQuery(TableMetadata tableMetadata) {
        StringBuilder sb = new StringBuilder("SELECT ");
        List columns = tableMetadata.getColumns();
        boolean first = true;
        for (ColumnMetadata column : columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(column.getName());
            first = false;
        }
        sb.append(" FROM ");
        sb.append(tableMetadata.getName());
        sb.append(" WHERE ");
        columns = tableMetadata.getPrimaryKey();
        first = true;
        for (ColumnMetadata column : columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(column.getName()).append(" = ?");
            first = false;
        }
        return sb.toString();
    }

    private static String insertQuery(TableMetadata tableMetadata) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableMetadata.getName()).append("(");
        List columns = tableMetadata.getColumns();
        boolean first = true;
        for (ColumnMetadata column : columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(column.getName());
            first = false;
        }
        sb.append(") VALUES(");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    private static <T> DatastaxMapper<T> selectMapper(Type target, TableMetadata tableMetadata, DatastaxMapperFactory mapperFactory) {
        DatastaxMapperBuilder mapperBuilder = mapperFactory.newBuilder(target);
        int i = 0;
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            mapperBuilder.addMapping(DatastaxColumnKey.of(columnMetadata, i++), new ColumnProperty[0]);
        }
        return (DatastaxMapper)mapperBuilder.mapper();
    }

    private static <K> BoundStatementMapper<K> keySetter(Type keyTarget, TableMetadata tableMetadata, DatastaxMapperFactory mapperFactory) {
        SettableDataMapperBuilder mapperBuilder = mapperFactory.newBuilderFrom(keyTarget);
        int i = 0;
        for (ColumnMetadata columnMetadata : tableMetadata.getPrimaryKey()) {
            mapperBuilder.addColumn(DatastaxColumnKey.of(columnMetadata, i++), new ColumnProperty[0]);
        }
        return new BoundStatementMapper(mapperBuilder.mapper());
    }

    private static <T> BoundStatementMapper<T> insertSetter(Type target, TableMetadata tableMetadata, DatastaxMapperFactory mapperFactory) {
        SettableDataMapperBuilder mapperBuilder = mapperFactory.newBuilderFrom(target);
        int i = 0;
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            mapperBuilder.addColumn(DatastaxColumnKey.of(columnMetadata, i++), new ColumnProperty[0]);
        }
        return new BoundStatementMapper(mapperBuilder.mapper());
    }
}

