/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import java.math.BigInteger;
import org.sfm.reflect.Getter;

public class DatastaxGenericBigIntegerGetter
implements Getter<GettableByIndexData, BigInteger> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericBigIntegerGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        switch (name) {
            case BIGINT: 
            case VARINT: 
            case INT: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case COUNTER: {
                return name;
            }
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public BigInteger get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return BigInteger.valueOf(target.getLong(this.index));
            }
            case VARINT: {
                return target.getVarint(this.index);
            }
            case INT: {
                return BigInteger.valueOf(target.getInt(this.index));
            }
            case DECIMAL: {
                return target.getDecimal(this.index).toBigInteger();
            }
            case FLOAT: {
                return BigInteger.valueOf((long)target.getFloat(this.index));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)target.getDouble(this.index));
            }
        }
        return null;
    }
}

