/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.Statement;
import org.sfm.datastax.BoundStatementMapper;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.SettableDataMapperBuilder;
import org.sfm.datastax.impl.SettableDataSetterFactory;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.impl.fieldmapper.ConstantTargetFieldMapperFactory;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactorImpl;
import org.sfm.map.mapper.MapperCache;
import org.sfm.map.mapper.MapperKey;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.meta.ClassMeta;

public class DatastaxBinder<T> {
    private final MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config;
    private final ClassMeta<T> classMeta;
    private final MapperCache<DatastaxColumnKey, BoundStatementMapper<T>> cache = new MapperCache();

    public DatastaxBinder(ClassMeta<T> classMeta, MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config) {
        this.classMeta = classMeta;
        this.config = config;
    }

    public BoundStatementMapper<T> mapTo(PreparedStatement statement) {
        return this.mapTo(statement.getVariables());
    }

    public BoundStatementMapper<T> mapTo(ColumnDefinitions variables) {
        MapperKey<DatastaxColumnKey> mapperKey = DatastaxColumnKey.mapperKey(variables);
        BoundStatementMapper<T> mapper = (BoundStatementMapper<T>)this.cache.get(mapperKey);
        if (mapper == null) {
            mapper = this.createMapper(mapperKey);
        }
        return mapper;
    }

    protected BoundStatementMapper<T> createMapper(MapperKey<DatastaxColumnKey> mapperKey) {
        SettableDataMapperBuilder<T> settableDataMapperBuilder = new SettableDataMapperBuilder<T>(this.classMeta, this.config, (ConstantTargetFieldMapperFactory<SettableByIndexData, DatastaxColumnKey>)ConstantTargetFieldMapperFactorImpl.instance((SetterFactory)new SettableDataSetterFactory(this.config, this.classMeta.getReflectionService())));
        for (DatastaxColumnKey columnKey : (DatastaxColumnKey[])mapperKey.getColumns()) {
            settableDataMapperBuilder.addColumn(columnKey, new ColumnProperty[0]);
        }
        BoundStatementMapper mapper = new BoundStatementMapper(settableDataMapperBuilder.mapper());
        this.cache.add(mapperKey, mapper);
        return mapper;
    }

    public Statement mapTo(T value, PreparedStatement preparedStatement) throws Exception {
        BoundStatementMapper<T> statementMapper = this.mapTo(preparedStatement);
        BoundStatement boundStatement = preparedStatement.bind();
        return statementMapper.mapTo(value, boundStatement);
    }
}

