/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax;

import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import java.lang.reflect.Type;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxMapper;
import org.sfm.datastax.DatastaxMapperBuilder;
import org.sfm.datastax.impl.DatastaxMappingContextFactoryBuilder;
import org.sfm.datastax.impl.RowGetterFactory;
import org.sfm.map.GetterFactory;
import org.sfm.map.MapperConfig;
import org.sfm.map.SetRowMapper;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.AbstractColumnDefinitionProvider;
import org.sfm.map.mapper.AbstractMapperFactory;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.DynamicSetRowMapper;
import org.sfm.map.mapper.FieldMapperColumnDefinitionProviderImpl;
import org.sfm.map.mapper.MapperKey;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.UnaryFactory;
import org.sfm.utils.UnaryFactoryWithException;

public class DatastaxMapperFactory
extends AbstractMapperFactory<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>, DatastaxMapperFactory> {
    private GetterFactory<GettableByIndexData, DatastaxColumnKey> getterFactory = new RowGetterFactory(this);

    private DatastaxMapperFactory() {
        super((AbstractColumnDefinitionProvider)new FieldMapperColumnDefinitionProviderImpl(), (ColumnDefinition)FieldMapperColumnDefinition.identity());
    }

    public static DatastaxMapperFactory newInstance() {
        return new DatastaxMapperFactory();
    }

    public <T> DatastaxMapperBuilder<T> newBuilder(Class<T> type) {
        return this.newBuilder((Type)type);
    }

    public <T> DatastaxMapperBuilder<T> newBuilder(TypeReference<T> type) {
        return this.newBuilder(type.getType());
    }

    public <T> DatastaxMapperBuilder<T> newBuilder(Type type) {
        ClassMeta classMeta = this.getClassMeta(type);
        return this.newBuilder(classMeta);
    }

    public <T> DatastaxMapperBuilder<T> newBuilder(ClassMeta<T> classMeta) {
        return new DatastaxMapperBuilder<T>(classMeta, (MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>>)this.mapperConfig(), this.getterFactory, new DatastaxMappingContextFactoryBuilder());
    }

    public <T> DatastaxMapper<T> mapTo(Class<T> type) {
        return this.mapTo((Type)type);
    }

    public <T> DatastaxMapper<T> mapTo(TypeReference<T> type) {
        return this.mapTo(type.getType());
    }

    public <T> DatastaxMapper<T> mapTo(Type type) {
        ClassMeta classMeta = this.getClassMeta(type);
        return new DynamicDatastaxSetRowMapper(new MapperFactory(classMeta), new MapperKeyFromRowFactory(), new MapperKeyFromSet());
    }

    private static class DynamicDatastaxSetRowMapper<T>
    extends DynamicSetRowMapper<Row, ResultSet, T, DriverException, DatastaxColumnKey>
    implements DatastaxMapper<T> {
        public DynamicDatastaxSetRowMapper(UnaryFactory<MapperKey<DatastaxColumnKey>, SetRowMapper<Row, ResultSet, T, DriverException>> mapperFactory, UnaryFactoryWithException<Row, MapperKey<DatastaxColumnKey>, DriverException> mapperKeyFromRow, UnaryFactoryWithException<ResultSet, MapperKey<DatastaxColumnKey>, DriverException> mapperKeyFromSet) {
            super(mapperFactory, mapperKeyFromRow, mapperKeyFromSet);
        }
    }

    private class MapperFactory<T>
    implements UnaryFactory<MapperKey<DatastaxColumnKey>, SetRowMapper<Row, ResultSet, T, DriverException>> {
        private final ClassMeta<T> classMeta;

        public MapperFactory(ClassMeta<T> classMeta) {
            this.classMeta = classMeta;
        }

        public SetRowMapper<Row, ResultSet, T, DriverException> newInstance(MapperKey<DatastaxColumnKey> datastaxColumnKeyMapperKey) {
            DatastaxMapperBuilder<T> builder = DatastaxMapperFactory.this.newBuilder(this.classMeta);
            for (DatastaxColumnKey key : (DatastaxColumnKey[])datastaxColumnKeyMapperKey.getColumns()) {
                builder.addMapping(key, new ColumnProperty[0]);
            }
            return (SetRowMapper)builder.mapper();
        }
    }

    private static class MapperKeyFromSet
    implements UnaryFactoryWithException<ResultSet, MapperKey<DatastaxColumnKey>, DriverException> {
        private MapperKeyFromSet() {
        }

        public MapperKey<DatastaxColumnKey> newInstance(ResultSet rows) throws DriverException {
            return DatastaxColumnKey.mapperKey(rows.getColumnDefinitions());
        }
    }

    private static class MapperKeyFromRowFactory
    implements UnaryFactoryWithException<Row, MapperKey<DatastaxColumnKey>, DriverException> {
        private MapperKeyFromRowFactory() {
        }

        public MapperKey<DatastaxColumnKey> newInstance(Row row) throws DriverException {
            return DatastaxColumnKey.mapperKey(row.getColumnDefinitions());
        }
    }
}

