/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.setter;

import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.SettableDataMapperBuilder;
import org.sfm.datastax.impl.SettableDataSetterFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactorImpl;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.meta.ClassMeta;

public class UDTObjectSettableDataSetter<T>
implements Setter<SettableByIndexData, T> {
    private final int index;
    private final UserType udtType;
    private final Mapper<T, SettableByIndexData> mapper;

    public UDTObjectSettableDataSetter(int index, UserType udtType, Mapper<T, SettableByIndexData> mapper) {
        this.index = index;
        this.udtType = udtType;
        this.mapper = mapper;
    }

    public void set(SettableByIndexData target, T value) throws Exception {
        if (value == null) {
            target.setToNull(this.index);
        } else {
            UDTValue udtValue = this.udtType.newValue();
            this.mapper.mapTo(value, (Object)udtValue, null);
            target.setUDTValue(this.index, udtValue);
        }
    }

    public static <T> Setter<SettableByIndexData, T> newInstance(Type target, UserType tt, int index, MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config, ReflectionService reflectionService) {
        Mapper<T, SettableByIndexData> mapper = UDTObjectSettableDataSetter.newUDTMapper(target, tt, config, reflectionService);
        return new UDTObjectSettableDataSetter<T>(index, tt, mapper);
    }

    public static <T> Mapper<T, SettableByIndexData> newUDTMapper(Type target, UserType tt, MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config, ReflectionService reflectionService) {
        SettableDataMapperBuilder<T> builder = UDTObjectSettableDataSetter.newFieldMapperBuilder(config, reflectionService, target);
        Iterator iterator = tt.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            UserType.Field f = (UserType.Field)iterator.next();
            builder.addColumn(new DatastaxColumnKey(f.getName(), i, f.getType()), new ColumnProperty[0]);
            ++i;
        }
        return builder.mapper();
    }

    public static <T> SettableDataMapperBuilder<T> newFieldMapperBuilder(MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config, ReflectionService reflectionService, Type target) {
        ClassMeta classMeta = reflectionService.getClassMeta(target);
        return new SettableDataMapperBuilder(classMeta, config, (ConstantTargetFieldMapperFactory<SettableByIndexData, DatastaxColumnKey>)ConstantTargetFieldMapperFactorImpl.instance((SetterFactory)new SettableDataSetterFactory(config, reflectionService)));
    }
}

