/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import java.math.BigDecimal;
import org.sfm.reflect.Getter;

public class DatastaxGenericBigDecimalGetter
implements Getter<GettableData, BigDecimal> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericBigDecimalGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        switch (name) {
            case BIGINT: 
            case VARINT: 
            case INT: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case COUNTER: {
                return name;
            }
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public BigDecimal get(GettableData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return BigDecimal.valueOf(target.getLong(this.index));
            }
            case VARINT: {
                return new BigDecimal(target.getVarint(this.index));
            }
            case INT: {
                return BigDecimal.valueOf(target.getInt(this.index));
            }
            case DECIMAL: {
                return target.getDecimal(this.index);
            }
            case FLOAT: {
                return BigDecimal.valueOf(target.getFloat(this.index));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(target.getDouble(this.index));
            }
        }
        return null;
    }
}

