/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;

public class ReflectionInstantiatorDefinitionFactory {
    public static List<InstantiatorDefinition> extractDefinitions(Type target) {
        InstantiatorDefinition definition;
        Class clazz = TypeHelper.toClass(target);
        ArrayList<InstantiatorDefinition> instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            definition = new InstantiatorDefinition(constructor, ReflectionInstantiatorDefinitionFactory.getParameters(constructor, target));
            instantiatorDefinitions.add(definition);
        }
        for (Executable executable : clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(((Method)executable).getModifiers()) || !Modifier.isStatic(((Method)executable).getModifiers()) || !clazz.isAssignableFrom(((Method)executable).getReturnType())) continue;
            definition = new InstantiatorDefinition(executable, ReflectionInstantiatorDefinitionFactory.getParameters((Method)executable, target));
            instantiatorDefinitions.add(definition);
        }
        return instantiatorDefinitions;
    }

    private static Parameter[] getParameters(Constructor<?> constructor, Type target) {
        return ReflectionInstantiatorDefinitionFactory.buildParameters(target, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), TypeHelper.toClass(target).getTypeParameters());
    }

    private static Parameter[] getParameters(Method method, Type target) {
        return ReflectionInstantiatorDefinitionFactory.buildParameters(target, method.getParameterTypes(), method.getGenericParameterTypes(), TypeHelper.toClass(target).getTypeParameters());
    }

    private static Parameter[] buildParameters(Type target, Class<?>[] parameterTypes, Type[] parameterGenericTypes, TypeVariable<Class<Object>>[] targetClassTypeParameters) {
        Parameter[] parameters = new Parameter[parameterTypes.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> paramType = parameterGenericTypes[i];
            String name = ReflectionInstantiatorDefinitionFactory.getName(i);
            Type resolvedParamType = null;
            if (paramType instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)((Object)paramType);
                paramType = parameterTypes[i];
                ParameterizedType pt = (ParameterizedType)target;
                for (TypeVariable<Class<Object>> typeParameter : targetClassTypeParameters) {
                    if (!typeParameter.getName().equals(tv.getName())) continue;
                    resolvedParamType = pt.getActualTypeArguments()[i];
                    break;
                }
            }
            if (resolvedParamType == null) {
                resolvedParamType = paramType;
            }
            parameters[i] = new Parameter(name, TypeHelper.toClass(paramType), resolvedParamType);
        }
        return parameters;
    }

    private static String getName(int i) {
        return "arg" + i;
    }
}

