/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import org.junit.Assert;
import org.sfm.beans.DbFinalObject;
import org.sfm.beans.DbObject;
import org.sfm.beans.DbObjectWithAlias;
import org.sfm.beans.DbPartialFinalObject;
import org.sfm.jdbc.TestRowHandler;
import org.sfm.utils.DateHelper;

public class DbHelper {
    public static final String TEST_DB_OBJECT_QUERY = "select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ";
    private static boolean objectDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection objectDb() throws SQLException {
        Connection c = DbHelper.newHsqlDbConnection();
        if (!objectDb) {
            try (Statement st = c.createStatement();){
                DbHelper.createDbObject(st);
                st.execute("insert into TEST_DB_OBJECT values(1, 'name 1', 'name1@mail.com', TIMESTAMP'2014-03-04 11:10:03', 2, 'type4')");
                st.execute("create table db_extended_type( bytes varbinary(10), url varchar(100),  time TIME(6), date DATE, bigdecimal decimal(10,3), biginteger bigint ,  stringArray VARCHAR(20) ARRAY DEFAULT ARRAY[], stringList VARCHAR(20) ARRAY DEFAULT ARRAY[] )");
                try (PreparedStatement ps = c.prepareStatement("insert into db_extended_type values (?, 'https://github.com/arnaudroger/SimpleFlatMapper','07:08:09', '2014-11-02', 123.321, 123, ARRAY [ 'HOT', 'COLD' ], ARRAY [ 'COLD', 'FREEZING' ])");){
                    ps.setBytes(1, new byte[]{97, 98, 99});
                    ps.execute();
                }
                c.commit();
            }
        }
        objectDb = true;
        return c;
    }

    public static void assertDbObjectMapping(DbObject dbObject) throws ParseException {
        Assert.assertEquals((long)1L, (long)dbObject.getId());
        Assert.assertEquals((Object)"name 1", (Object)dbObject.getName());
        Assert.assertEquals((Object)"name1@mail.com", (Object)dbObject.getEmail());
        Assert.assertEquals((Object)DateHelper.toDate("2014-03-04 11:10:03"), (Object)dbObject.getCreationTime());
        Assert.assertEquals((Object)((Object)DbObject.Type.type3), (Object)((Object)dbObject.getTypeOrdinal()));
        Assert.assertEquals((Object)((Object)DbObject.Type.type4), (Object)((Object)dbObject.getTypeName()));
    }

    public static void assertDbObjectWithAliasMapping(DbObjectWithAlias dbObject) throws ParseException {
        Assert.assertEquals((long)1L, (long)dbObject.getIdWithAlias());
        Assert.assertEquals((Object)"name 1", (Object)dbObject.getNameWithAlias());
        Assert.assertEquals((Object)"name1@mail.com", (Object)dbObject.getEmailWithAlias());
        Assert.assertEquals((Object)DateHelper.toDate("2014-03-04 11:10:03"), (Object)dbObject.getCreationTimeWithAlias());
        Assert.assertEquals((Object)((Object)DbObject.Type.type3), (Object)((Object)dbObject.getTypeOrdinalWithAlias()));
        Assert.assertEquals((Object)((Object)DbObject.Type.type4), (Object)((Object)dbObject.getTypeNameWithAlias()));
    }

    public static void assertDbObjectMapping(int i, DbObject dbObject) throws ParseException {
        Assert.assertEquals((long)i, (long)dbObject.getId());
        Assert.assertEquals((Object)("name " + i), (Object)dbObject.getName());
        Assert.assertEquals((Object)("name" + i + "@mail.com"), (Object)dbObject.getEmail());
        Assert.assertEquals((Object)DateHelper.toDate("2014-03-04 11:10:03"), (Object)dbObject.getCreationTime());
        Assert.assertEquals((Object)((Object)DbObject.Type.type3), (Object)((Object)dbObject.getTypeOrdinal()));
        Assert.assertEquals((Object)((Object)DbObject.Type.type4), (Object)((Object)dbObject.getTypeName()));
    }

    public static void assertDbObjectMapping(DbFinalObject dbObject) throws ParseException {
        Assert.assertEquals((long)1L, (long)dbObject.getId());
        Assert.assertEquals((Object)"name 1", (Object)dbObject.getName());
        Assert.assertEquals((Object)"name1@mail.com", (Object)dbObject.getEmail());
        Assert.assertEquals((Object)DateHelper.toDate("2014-03-04 11:10:03"), (Object)dbObject.getCreationTime());
        Assert.assertEquals((Object)((Object)DbObject.Type.type3), (Object)((Object)dbObject.getTypeOrdinal()));
        Assert.assertEquals((Object)((Object)DbObject.Type.type4), (Object)((Object)dbObject.getTypeName()));
    }

    public static void assertDbObjectMapping(DbPartialFinalObject dbObject) throws ParseException {
        Assert.assertEquals((long)1L, (long)dbObject.getId());
        Assert.assertEquals((Object)"name 1", (Object)dbObject.getName());
        Assert.assertEquals((Object)"name1@mail.com", (Object)dbObject.getEmail());
        Assert.assertEquals((Object)DateHelper.toDate("2014-03-04 11:10:03"), (Object)dbObject.getCreationTime());
        Assert.assertEquals((Object)((Object)DbObject.Type.type3), (Object)((Object)dbObject.getTypeOrdinal()));
        Assert.assertEquals((Object)((Object)DbObject.Type.type4), (Object)((Object)dbObject.getTypeName()));
    }

    private static void createDbObject(Statement st) throws SQLException {
        st.execute("create table test_db_object( id bigint not null primary key, name varchar(100),  email varchar(100), creation_Time timestamp, type_ordinal int, type_name varchar(10)  )");
    }

    private static Connection newHsqlDbConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:hsqldb:mem:mymemdb", "SA", "");
    }

    public static void testDbObjectFromDb(TestRowHandler<PreparedStatement> handler) throws SQLException, Exception, ParseException {
        String query = TEST_DB_OBJECT_QUERY;
        DbHelper.testQuery(handler, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testQuery(TestRowHandler<PreparedStatement> handler, String query) throws SQLException, Exception {
        try (Connection conn = DbHelper.objectDb();
             PreparedStatement ps = conn.prepareStatement(query);){
            handler.handle(ps);
        }
    }
}

