/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.GettableData;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.impl.DatastaxBigDecimalGetter;
import org.sfm.datastax.impl.DatastaxBigIntegerGetter;
import org.sfm.datastax.impl.DatastaxBooleanGetter;
import org.sfm.datastax.impl.DatastaxDateGetter;
import org.sfm.datastax.impl.DatastaxDoubleGetter;
import org.sfm.datastax.impl.DatastaxFloatGetter;
import org.sfm.datastax.impl.DatastaxInetAddressGetter;
import org.sfm.datastax.impl.DatastaxIntegerGetter;
import org.sfm.datastax.impl.DatastaxLongGetter;
import org.sfm.datastax.impl.DatastaxObjectGetter;
import org.sfm.datastax.impl.DatastaxStringGetter;
import org.sfm.datastax.impl.DatastaxUUIDGetter;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.GetterFactory;
import org.sfm.map.impl.getter.EnumUnspecifiedTypeGetter;
import org.sfm.map.impl.getter.OrdinalEnumGetter;
import org.sfm.map.impl.getter.StringEnumGetter;
import org.sfm.map.impl.getter.joda.JodaTimeGetterFactory;
import org.sfm.map.impl.getter.time.JavaTimeGetterFactory;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;

public class RowGetterFactory
implements GetterFactory<GettableData, DatastaxColumnKey> {
    private final HashMap<Class<?>, GetterFactory<GettableData, DatastaxColumnKey>> getterFactories = new HashMap();
    private final GetterFactory<GettableData, DatastaxColumnKey> dateGetterFactory = new GetterFactory<GettableData, DatastaxColumnKey>(){

        @Override
        public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
            return new DatastaxDateGetter(key.getIndex());
        }
    };
    private JodaTimeGetterFactory<GettableData, DatastaxColumnKey> jodaTimeGetterFactory;

    public RowGetterFactory() {
        JavaTimeGetterFactory<GettableData, DatastaxColumnKey> javaTimeGetterFactory = new JavaTimeGetterFactory<GettableData, DatastaxColumnKey>(this.dateGetterFactory);
        this.getterFactories.put(LocalDate.class, javaTimeGetterFactory);
        this.getterFactories.put(LocalDateTime.class, javaTimeGetterFactory);
        this.getterFactories.put(LocalTime.class, javaTimeGetterFactory);
        this.getterFactories.put(OffsetDateTime.class, javaTimeGetterFactory);
        this.getterFactories.put(OffsetTime.class, javaTimeGetterFactory);
        this.getterFactories.put(ZonedDateTime.class, javaTimeGetterFactory);
        this.getterFactories.put(Instant.class, javaTimeGetterFactory);
        this.getterFactories.put(Year.class, javaTimeGetterFactory);
        this.getterFactories.put(YearMonth.class, javaTimeGetterFactory);
        this.jodaTimeGetterFactory = new JodaTimeGetterFactory<GettableData, DatastaxColumnKey>(this.dateGetterFactory);
    }

    @Override
    public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Getter getter;
        Class targetClass = TypeHelper.toClass(target);
        if (String.class.equals(targetClass)) {
            return new DatastaxStringGetter(key.getIndex());
        }
        if (Date.class.equals(targetClass)) {
            return new DatastaxDateGetter(key.getIndex());
        }
        if (Long.class.equals(targetClass) || Long.TYPE.equals(targetClass)) {
            return new DatastaxLongGetter(key.getIndex());
        }
        if (Integer.class.equals(targetClass) || Integer.TYPE.equals(targetClass)) {
            return new DatastaxIntegerGetter(key.getIndex());
        }
        if (Float.class.equals(targetClass) || Float.TYPE.equals(targetClass)) {
            return new DatastaxFloatGetter(key.getIndex());
        }
        if (Double.class.equals(targetClass) || Double.TYPE.equals(targetClass)) {
            return new DatastaxDoubleGetter(key.getIndex());
        }
        if (Boolean.TYPE.equals(targetClass) || Boolean.class.equals(targetClass)) {
            return new DatastaxBooleanGetter(key.getIndex());
        }
        if (BigDecimal.class.equals(targetClass)) {
            return new DatastaxBigDecimalGetter(key.getIndex());
        }
        if (BigInteger.class.equals(targetClass)) {
            return new DatastaxBigIntegerGetter(key.getIndex());
        }
        if (UUID.class.equals(targetClass)) {
            return new DatastaxUUIDGetter(key.getIndex());
        }
        if (InetAddress.class.equals(targetClass)) {
            return new DatastaxInetAddressGetter(key.getIndex());
        }
        if (TypeHelper.isEnum(target) && (getter = this.enumGetter(key, TypeHelper.toClass(target))) != null) {
            return getter;
        }
        GetterFactory<GettableData, DatastaxColumnKey> rowGetterFactory = this.getterFactories.get(targetClass);
        if (rowGetterFactory != null) {
            return rowGetterFactory.newGetter(target, key, columnDefinition);
        }
        Getter getter2 = this.jodaTimeGetterFactory.newGetter(target, key, columnDefinition);
        if (getter2 != null) {
            return getter2;
        }
        return null;
    }

    public <E extends Enum<E>> Getter<GettableData, E> enumGetter(DatastaxColumnKey key, Class<?> enumClass) {
        if (key.getDateType() != null) {
            Class javaClass;
            Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
            if (Number.class.isAssignableFrom(javaClass)) {
                return new OrdinalEnumGetter(new DatastaxIntegerGetter(key.getIndex()), enumClass);
            }
            if (String.class.equals((Object)javaClass)) {
                return new StringEnumGetter(new DatastaxStringGetter(key.getIndex()), enumClass);
            }
        } else {
            return new EnumUnspecifiedTypeGetter(new DatastaxObjectGetter(key.getIndex()), enumClass);
        }
        return null;
    }
}

