/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvRow;
import org.simpleflatmapper.lightningcsv.CsvReader;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;

public final class CsvRowSet
implements Enumerable<CsvRow> {
    private final CsvReader csvReader;
    private final CharBuffer charBuffer;
    private CsvRow currentRow;
    private CellConsumer cellConsumer;
    private int limit;
    private CsvColumnKey[] keys;
    private boolean finished;

    public CsvRowSet(CsvReader csvReader, int limit) {
        this.csvReader = csvReader;
        this.charBuffer = csvReader.charBuffer();
        this.limit = limit;
    }

    public CsvRowSet(CsvReader csvReader, int limit, CsvColumnKey[] keys) {
        this.csvReader = csvReader;
        this.charBuffer = csvReader.charBuffer();
        this.currentRow = new CsvRow(keys, this.maxIndex(keys), this.charBuffer);
        this.cellConsumer = csvReader.wrapConsumer((CellConsumer)this.currentRow);
        this.limit = limit;
        this.keys = keys;
    }

    public CsvColumnKey[] getKeys() throws IOException {
        if (this.keys == null) {
            this.keys = this.fetchKeys();
            this.currentRow = new CsvRow(this.keys, this.maxIndex(this.keys), this.charBuffer);
            this.cellConsumer = this.csvReader.wrapConsumer((CellConsumer)this.currentRow);
        }
        return this.keys;
    }

    private int maxIndex(CsvColumnKey[] keys) {
        int i = 0;
        for (CsvColumnKey k : keys) {
            if (k == null) continue;
            i = Math.max(i, k.getIndex());
        }
        return i;
    }

    private CsvColumnKey[] fetchKeys() throws IOException {
        KeysCellConsumer keysCellConsumer = new KeysCellConsumer();
        this.csvReader.parseRow((CellConsumer)keysCellConsumer);
        return keysCellConsumer.getKeys();
    }

    public boolean next() {
        if (this.finished || this.limit == 0) {
            return false;
        }
        this.currentRow.reset();
        try {
            if (this.limit != -1) {
                --this.limit;
            }
            do {
                boolean bl = this.finished = !this.csvReader.rawParseRow(this.cellConsumer, true);
                if (!this.currentRow.hasData()) continue;
                return true;
            } while (!this.finished);
            return false;
        }
        catch (IOException e) {
            return (Boolean)ErrorHelper.rethrow((Throwable)e);
        }
    }

    public CsvRow currentValue() {
        return this.currentRow;
    }

    private static class KeysCellConsumer
    implements CellConsumer {
        private static final CsvColumnKey[] EMPTY_KEYS = new CsvColumnKey[0];
        private final List<CsvColumnKey> keyList = new ArrayList<CsvColumnKey>(10);

        public void newCell(char[] chars, int offset, int length) {
            this.keyList.add(new CsvColumnKey(new String(chars, offset, length), this.keyList.size()));
        }

        public boolean endOfRow() {
            return true;
        }

        public void end() {
        }

        public CsvColumnKey[] getKeys() {
            return this.keyList.toArray(EMPTY_KEYS);
        }
    }
}

