/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public final class YamlCellPreProcessor
extends CellPreProcessor {
    private static final int COMMENT = 2;
    private static final int REGULAR_ROW = 1;
    private static final int NONE = 0;
    private final boolean ignoreLeadingSpace;

    public YamlCellPreProcessor(boolean ignoreLeadingSpace) {
        this.ignoreLeadingSpace = ignoreLeadingSpace;
    }

    @Override
    public void newCell(char[] chars, int start, int end, CellConsumer cellConsumer, int state) {
        YamlCellConsumer yamlCellConsumer = (YamlCellConsumer)cellConsumer;
        yamlCellConsumer.newCell(chars, start, end, state);
    }

    @Override
    public boolean ignoreLeadingSpace() {
        return this.ignoreLeadingSpace;
    }

    public static final class YamlCellConsumer
    implements CellConsumer {
        public final CellConsumer rowDelegate;
        public final CheckedConsumer<String> commentConsumer;
        public final CellPreProcessor rowCellPreProcessor;
        private int rowState;

        public YamlCellConsumer(CellConsumer rowDelegate, CheckedConsumer<String> commentConsumer, CellPreProcessor rowCellPreProcessor) {
            this.rowDelegate = (CellConsumer)Asserts.requireNonNull((String)"rowDelegate", (Object)rowDelegate);
            this.commentConsumer = commentConsumer;
            this.rowCellPreProcessor = rowCellPreProcessor;
        }

        @Override
        public void newCell(char[] chars, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void newCell(char[] chars, int start, int end, int state) {
            if ((state & 0x20) == 0) {
                this.rowCellPreProcessor.newCell(chars, start, end, this.rowDelegate, state);
                this.rowState = 1;
            } else {
                if (this.commentConsumer != null) {
                    try {
                        this.commentConsumer.accept((Object)new String(chars, start, end - start));
                    }
                    catch (Exception e) {
                        ErrorHelper.rethrow((Throwable)e);
                    }
                }
                this.rowState = 2;
            }
        }

        @Override
        public boolean endOfRow() {
            boolean b = this.rowState != 2 ? this.rowDelegate.endOfRow() : this.commentConsumer != null;
            this.rowState = 0;
            return b;
        }

        @Override
        public void end() {
            if (this.rowState == 1) {
                this.rowDelegate.endOfRow();
            }
            this.rowDelegate.end();
        }
    }
}

