/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.ToStringConverter;
import org.simpleflatmapper.csv.CellWriter;
import org.simpleflatmapper.csv.CsvCellWriter;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvWriterBuilder;
import org.simpleflatmapper.csv.mapper.FieldMapperToAppendableFactory;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.PropertyWithGetter;
import org.simpleflatmapper.map.mapper.ContextualMapper;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.FormatProperty;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.TypeReference;

public class CsvWriter<T> {
    private final Mapper<T, Appendable> mapper;
    private final Appendable appendable;
    private final MappingContext<T> mappingContext;

    private CsvWriter(Mapper<T, Appendable> mapper, Appendable appendable, MappingContext<T> mappingContext) {
        this.mapper = mapper;
        this.appendable = appendable;
        this.mappingContext = mappingContext;
    }

    public CsvWriter<T> append(T value) throws IOException {
        try {
            this.mapper.mapTo(value, (Object)this.appendable, this.mappingContext);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        return this;
    }

    public static <T> CsvWriterDSL<T> from(Class<T> type) {
        return CsvWriter.from(type);
    }

    public static <T> CsvWriterDSL<T> from(TypeReference<T> typeReference) {
        return CsvWriter.from(typeReference.getType());
    }

    public static <T> CsvWriterDSL<T> from(Type type) {
        ClassMeta classMeta = ReflectionService.newInstance().getClassMeta(type);
        CsvCellWriter cellWriter = CsvCellWriter.DEFAULT_WRITER;
        CsvWriterBuilder builder = CsvWriterBuilder.newBuilder(classMeta, cellWriter);
        MapperConfig mapperConfig = MapperConfig.fieldMapperConfig();
        try {
            String[] headers;
            for (String header : headers = CsvWriter.defaultHeaders(classMeta)) {
                builder.addColumn(header);
            }
            ContextualMapper mapper = (ContextualMapper)builder.mapper();
            return new DefaultCsvWriterDSL(CsvWriter.toColumnDefinitions(headers), cellWriter, mapper, classMeta, mapperConfig, false);
        }
        catch (UnsupportedOperationException e) {
            return new NoColumnCsvWriterDSL(cellWriter, classMeta, (MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>>)mapperConfig, false);
        }
    }

    private static <T> String[] defaultHeaders(ClassMeta<T> classMeta) {
        ArrayList<String> columns = new ArrayList<String>();
        CsvWriter.addDefaultHeaders(classMeta, "", columns);
        return columns.toArray(new String[0]);
    }

    private static <P> void addDefaultHeaders(ClassMeta<P> classMeta, final String prefix, final List<String> columns) {
        classMeta.forEachProperties(new Consumer<PropertyMeta<P, ?>>(){

            public void accept(PropertyMeta<P, ?> propertyMeta) {
                if (!PropertyWithGetter.INSTANCE.test(propertyMeta)) {
                    return;
                }
                String currentName = prefix + propertyMeta.getPath();
                if (!CsvWriter.canWrite(propertyMeta.getPropertyType())) {
                    CsvWriter.addDefaultHeaders(propertyMeta.getPropertyClassMeta(), currentName + "_", columns);
                } else {
                    columns.add(CsvWriter.toDelimiterSeparated(currentName));
                }
            }
        });
    }

    private static String toDelimiterSeparated(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        boolean lastWasUpperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                if (lastWasUpperCase) {
                    sb.append(c);
                } else {
                    if (i > 0) {
                        sb.append('_');
                    }
                    sb.append(Character.toLowerCase(c));
                }
                lastWasUpperCase = true;
                continue;
            }
            lastWasUpperCase = false;
            sb.append(c);
        }
        return sb.toString();
    }

    private static <P, E> boolean canWrite(Type type) {
        Converter converter = ConverterService.getInstance().findConverter(type, CharSequence.class, new Object[0]);
        return converter != null && (!(converter instanceof ToStringConverter) || CsvWriter.allowToStringConverter(type));
    }

    private static boolean allowToStringConverter(Type type) {
        return TypeHelper.isPrimitive((Type)type) || TypeHelper.isEnum((Type)type) || TypeHelper.isInPackage((Type)type, (Predicate)new Predicate<String>(){

            public boolean test(String s) {
                return s.startsWith("java.");
            }
        });
    }

    private static <T> Column[] toColumnDefinitions(String[] header) {
        Column[] columnDefinitions = new Column[header.length];
        int offset = 0;
        return CsvWriter.toColumnDefinitions(header, columnDefinitions, offset);
    }

    private static Column[] toColumnDefinitions(String[] header, Column[] columnDefinitions, int offset) {
        FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
        for (int i = 0; i < header.length; ++i) {
            columnDefinitions[i + offset] = new Column(header[i], (FieldMapperColumnDefinition<CsvColumnKey>)identity);
        }
        return columnDefinitions;
    }

    public static class Column {
        private final String name;
        private final FieldMapperColumnDefinition<CsvColumnKey> definition;

        public Column(String name, FieldMapperColumnDefinition<CsvColumnKey> definition) {
            this.name = name;
            this.definition = definition;
        }

        public String name() {
            return this.name;
        }

        public FieldMapperColumnDefinition<CsvColumnKey> definition() {
            return this.definition;
        }
    }

    public static class DefaultCsvWriterDSL<T>
    extends CsvWriterDSL<T> {
        private DefaultCsvWriterDSL(Column[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            super(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }

        @Override
        public CsvWriterDSL<T> columns(String ... columnNames) {
            return this.newColumnMapDSL(this.classMeta, CsvWriter.toColumnDefinitions(columnNames), (MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>>)this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        @Override
        public CsvWriterDSL<T> column(String column, Object ... property) {
            Column[] newColumns = new Column[1];
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(property);
            newColumns[0] = new Column(column, (FieldMapperColumnDefinition<CsvColumnKey>)columnDefinition);
            return this.newColumnMapDSL(this.classMeta, newColumns, (MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>>)this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        @Override
        protected CsvWriterDSL<T> newCsvWriterDSL(Column[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            return new DefaultCsvWriterDSL<T>(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }
    }

    public static class NoColumnCsvWriterDSL<T>
    extends CsvWriterDSL<T> {
        public NoColumnCsvWriterDSL(CellWriter cellWriter, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            super(new Column[0], cellWriter, null, classMeta, mapperConfig, skipHeaders);
        }

        @Override
        public CsvWriter<T> to(Appendable appendable) throws IOException {
            throw new IllegalStateException("No column defined");
        }

        @Override
        protected NoColumnCsvWriterDSL<T> newCsvWriterDSL(Column[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            return new NoColumnCsvWriterDSL<T>(cellWriter, classMeta, mapperConfig, skipHeaders);
        }
    }

    public static class CsvWriterDSL<T> {
        protected final Column[] columns;
        protected final ContextualMapper<T, Appendable> mapper;
        protected final CellWriter cellWriter;
        protected final ClassMeta<T> classMeta;
        protected final MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig;
        protected final boolean skipHeaders;

        private CsvWriterDSL(Column[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            this.columns = columns;
            this.mapper = mapper;
            this.cellWriter = cellWriter;
            this.classMeta = classMeta;
            this.mapperConfig = mapperConfig;
            this.skipHeaders = skipHeaders;
        }

        public CsvWriter<T> to(Appendable appendable) throws IOException {
            if (!this.skipHeaders) {
                this.addHeaders(appendable);
            }
            return new CsvWriter((Mapper)this.mapper, appendable, this.mapper.newMappingContext());
        }

        private void addHeaders(Appendable appendable) throws IOException {
            for (int i = 0; i < this.columns.length; ++i) {
                if (i != 0) {
                    this.cellWriter.nextCell(appendable);
                }
                this.cellWriter.writeValue(this.columns[i].name(), appendable);
            }
            this.cellWriter.endOfRow(appendable);
        }

        public CsvWriterDSL<T> columns(String ... columnNames) {
            Column[] newColumns = Arrays.copyOf(this.columns, this.columns.length + columnNames.length);
            CsvWriter.toColumnDefinitions(columnNames, newColumns, this.columns.length);
            return this.newColumnMapDSL(this.classMeta, newColumns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> column(String column, Object ... property) {
            Column[] newColumns = Arrays.copyOf(this.columns, this.columns.length + 1);
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(property);
            newColumns[this.columns.length] = new Column(column, (FieldMapperColumnDefinition<CsvColumnKey>)columnDefinition);
            return this.newColumnMapDSL(this.classMeta, newColumns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> column(String column, Format format) {
            return this.column(column, new FormatProperty(format));
        }

        public CsvWriterDSL<T> classMeta(ClassMeta<T> classMeta) {
            return this.newMapDSL(classMeta, this.columns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> mapperConfig(MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig) {
            return this.newMapDSL(this.classMeta, this.columns, mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> cellWriter(CellWriter cellWriter) {
            return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> separator(char separator) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).separator(separator), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> quote(char quote) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).quote(quote), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> escape(char escape) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).escape(escape), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> endOfLine(String endOfLine) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).endOfLine(endOfLine), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> alwaysEscape() {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).alwaysEscape(), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> skipHeaders() {
            return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, this.cellWriter, true);
        }

        public MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig() {
            return this.mapperConfig;
        }

        protected CsvWriterDSL<T> newColumnMapDSL(ClassMeta<T> classMeta, Column[] columns, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, CellWriter cellWriter, boolean skipHeaders) {
            CsvWriterBuilder<T> builder = new CsvWriterBuilder<T>(classMeta, mapperConfig, new FieldMapperToAppendableFactory(cellWriter), cellWriter);
            for (Column col : columns) {
                builder.addColumn(col.name(), col.definition());
            }
            ContextualMapper mapper = (ContextualMapper)builder.mapper();
            return new CsvWriterDSL<T>(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }

        protected CsvWriterDSL<T> newMapDSL(ClassMeta<T> classMeta, Column[] columns, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, CellWriter cellWriter, boolean skipHeaders) {
            CsvWriterBuilder<T> builder = new CsvWriterBuilder<T>(classMeta, mapperConfig, new FieldMapperToAppendableFactory(cellWriter), cellWriter);
            for (Column col : columns) {
                builder.addColumn(col.name(), col.definition());
            }
            ContextualMapper mapper = (ContextualMapper)builder.mapper();
            return this.newCsvWriterDSL(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }

        protected CsvWriterDSL<T> newCsvWriterDSL(Column[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            return new CsvWriterDSL<T>(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }
    }
}

