/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.mapper;

import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.mapper.CsvMapperCellConsumer;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.util.ErrorHelper;

public abstract class CsvMapperCellHandler<T> {
    protected final Instantiator<CsvMapperCellHandler<T>, T> instantiator;
    protected final CsvColumnKey[] columns;
    protected final int totalLength;
    protected final int delayedCellSettersLength;
    protected final ParsingContext parsingContext;
    protected final FieldMapperErrorHandler<? super CsvColumnKey> fieldErrorHandler;
    protected CsvMapperCellConsumer<T> mapperCellConsumer;
    protected T currentInstance;

    public CsvMapperCellHandler(Instantiator<CsvMapperCellHandler<T>, T> instantiator, CsvColumnKey[] columns, int delayedCellSettersLength, int cellSettersLength, ParsingContext parsingContext, FieldMapperErrorHandler<? super CsvColumnKey> fieldErrorHandler) {
        this.instantiator = instantiator;
        this.columns = columns;
        this.parsingContext = parsingContext;
        this.fieldErrorHandler = fieldErrorHandler;
        this.totalLength = delayedCellSettersLength + cellSettersLength;
        this.delayedCellSettersLength = delayedCellSettersLength;
    }

    public abstract void delayedCellValue(char[] var1, int var2, int var3, int var4);

    public abstract void cellValue(char[] var1, int var2, int var3, int var4);

    public abstract void applyDelayedSetters();

    public abstract DelayedCellSetter<T, ?> getDelayedCellSetter(int var1);

    public abstract Object peekDelayedCellSetterValue(CsvColumnKey var1);

    public final void createInstance() {
        try {
            this.currentInstance = this.instantiator.newInstance((Object)this);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
    }

    public final boolean isDelayedSetter(int cellIndex) {
        return cellIndex < this.delayedCellSettersLength;
    }

    protected final void fieldError(int cellIndex, Exception e) {
        if (this.fieldErrorHandler == null) {
            ErrorHelper.rethrow((Throwable)e);
        }
        this.fieldErrorHandler.errorMappingField((Object)this.getColumn(cellIndex), (Object)this, this.mapperCellConsumer.getRootCurrentInstance(), e);
    }

    private CsvColumnKey getColumn(int cellIndex) {
        for (CsvColumnKey key : this.columns) {
            if (key.getIndex() != cellIndex) continue;
            return key;
        }
        return null;
    }

    public final T getCurrentInstance() {
        return this.currentInstance;
    }

    public final void createInstanceIfNull() {
        if (this.currentInstance == null) {
            this.createInstance();
        }
    }

    public final void resetCurrentInstance() {
        this.currentInstance = null;
    }

    public final boolean hasInstance() {
        return this.currentInstance != null;
    }
}

