/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simpleflatmapper.csv.parser.BufferOverflowException;
import org.simpleflatmapper.csv.parser.CharBuffer;

public final class ReaderCharBuffer
extends CharBuffer {
    private final int maxBufferSize;
    private final Reader reader;
    private final int readSize;

    public ReaderCharBuffer(int readSize, int maxBufferLength, Reader reader) {
        super(new char[readSize < 4096 ? readSize : readSize * 2], 0);
        this.readSize = readSize;
        this.maxBufferSize = maxBufferLength;
        this.reader = reader;
    }

    @Override
    public final boolean next() throws IOException {
        int l;
        int currentSize = this.bufferSize;
        int effectiveMark = Math.min(currentSize, this.mark);
        int newSize = currentSize - effectiveMark;
        char[] lbuffer = this.buffer;
        System.arraycopy(lbuffer, effectiveMark, lbuffer, 0, newSize);
        this.mark = 0;
        int bufferLength = lbuffer.length;
        int availableSpace = bufferLength - newSize;
        int effectiveReadSize = this.readSize;
        if (availableSpace < effectiveReadSize) {
            int newBufferSize = bufferLength * 2;
            if (newBufferSize < bufferLength + effectiveReadSize) {
                newBufferSize = bufferLength + effectiveReadSize;
            }
            if (newBufferSize > this.maxBufferSize) {
                newBufferSize = this.maxBufferSize;
            }
            if (newBufferSize <= newSize) {
                throw new BufferOverflowException("The content in the csv cell exceed the maxSizeBuffer " + this.maxBufferSize + ", see CsvParser.DSL.maxSizeBuffer(int) to change the default value");
            }
            this.buffer = lbuffer = Arrays.copyOf(lbuffer, newBufferSize);
            if (effectiveReadSize > bufferLength - newSize) {
                effectiveReadSize = bufferLength - newSize;
            }
        }
        if ((l = this.reader.read(lbuffer, newSize, effectiveReadSize)) >= 0) {
            this.bufferSize = newSize + l;
            return true;
        }
        this.bufferSize = newSize;
        return false;
    }
}

