/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.reflect.Instantiator;

public final class CsvMapperCellHandlerImpl<T>
extends CsvMapperCellHandler<T> {
    protected final DelayedCellSetter<T, ?>[] delayedCellSetters;
    protected final CellSetter<T>[] setters;

    public CsvMapperCellHandlerImpl(Instantiator<CsvMapperCellHandler<T>, T> instantiator, DelayedCellSetter<T, ?>[] delayedCellSetters, CellSetter<T>[] setters, CsvColumnKey[] columns, ParsingContext parsingContext, FieldMapperErrorHandler<? super CsvColumnKey> fieldErrorHandler) {
        super(instantiator, columns, delayedCellSetters.length, setters.length, parsingContext, fieldErrorHandler);
        this.delayedCellSetters = delayedCellSetters;
        this.setters = setters;
    }

    @Override
    public void delayedCellValue(char[] chars, int offset, int length, int cellIndex) {
        try {
            DelayedCellSetter<T, ?> delayedCellSetter = this.delayedCellSetters[cellIndex];
            if (delayedCellSetter != null) {
                delayedCellSetter.set(chars, offset, length, this.parsingContext);
            }
        }
        catch (Exception e) {
            this.fieldError(cellIndex, e);
        }
    }

    @Override
    public void cellValue(char[] chars, int offset, int length, int cellIndex) {
        try {
            CellSetter<Object> cellSetter = this.getCellSetter(cellIndex);
            if (cellSetter != null) {
                cellSetter.set(this.currentInstance, chars, offset, length, this.parsingContext);
            }
        }
        catch (Exception e) {
            this.fieldError(cellIndex, e);
        }
    }

    @Override
    public void applyDelayedSetters() {
        for (int i = 0; i < this.delayedCellSetters.length; ++i) {
            DelayedCellSetter<Object, ?> delayedSetter = this.delayedCellSetters[i];
            if (delayedSetter == null || !delayedSetter.isSettable()) continue;
            try {
                delayedSetter.set(this.currentInstance);
                continue;
            }
            catch (Exception e) {
                this.fieldError(i, e);
            }
        }
    }

    @Override
    public DelayedCellSetter<T, ?> getDelayedCellSetter(int index) {
        return this.delayedCellSetters[index];
    }

    @Override
    public final Object peekDelayedCellSetterValue(CsvColumnKey key) {
        return this.delayedCellSetters[key.getIndex()].peekValue();
    }

    private CellSetter<T> getCellSetter(int cellIndex) {
        int i = cellIndex - this.delayedCellSetters.length;
        if (i < this.setters.length) {
            return this.setters[i];
        }
        return null;
    }
}

