/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellTransformer;

public final class UnescapeCellTransformer
extends CellTransformer {
    private final char escapeChar;

    public UnescapeCellTransformer(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    @Override
    public final void newCell(char[] chars, int start, int end, CellConsumer cellConsumer) {
        int strStart = start;
        int strEnd = end;
        if (strStart < strEnd && chars[strStart] == this.escapeChar) {
            strEnd = this.unescape(chars, ++strStart, strEnd);
        }
        cellConsumer.newCell(chars, strStart, strEnd - strStart);
    }

    private int unescape(char[] chars, int start, int end) {
        for (int i = start; i < end - 1; ++i) {
            if (chars[i] != this.escapeChar) continue;
            return this.removeEscapeChars(chars, end, i);
        }
        if (start < end && chars[end - 1] == this.escapeChar) {
            return end - 1;
        }
        return end;
    }

    private int removeEscapeChars(char[] chars, int end, int firstEscapeChar) {
        int j = firstEscapeChar;
        boolean escaped = true;
        for (int i = firstEscapeChar + 1; i < end; ++i) {
            boolean bl = escaped = chars[i] == this.escapeChar && !escaped;
            if (escaped) continue;
            chars[j++] = chars[i];
        }
        return j;
    }
}

