/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellTransformer;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.CharConsumer;
import org.simpleflatmapper.csv.parser.TextFormat;
import org.simpleflatmapper.csv.parser.TrimAndUnescapeCellTransformer;

public final class ConfigurableCharConsumer
extends CharConsumer {
    private final char escapeChar;
    private final char separatorChar;
    private CellTransformer cellTransformer;

    public ConfigurableCharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellTransformer cellTransformer) {
        super(csvBuffer, cellTransformer instanceof TrimAndUnescapeCellTransformer);
        this.cellTransformer = cellTransformer;
        this.escapeChar = textFormat.getEscapeChar();
        this.separatorChar = textFormat.getSeparatorChar();
    }

    @Override
    protected final boolean isSeparator(char character) {
        return character == this.separatorChar;
    }

    @Override
    protected final boolean isNotEscapeCharacter(char character) {
        return character != this.escapeChar;
    }

    @Override
    protected void pushCell(char[] chars, int start, int end, CellConsumer cellConsumer) {
        this.cellTransformer.newCell(chars, start, end, cellConsumer);
    }
}

