/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellUtil;

public final class IgnoreYamlCommentUnescapeContentCellConsumer
implements CellConsumer {
    private static final int COMMENT = 2;
    private static final int REGULAR_ROW = 1;
    private static final int NONE = 0;
    private final char escapeChar;
    private final CellConsumer delegate;
    private int state;

    public IgnoreYamlCommentUnescapeContentCellConsumer(char escapeChar, CellConsumer delegate) {
        this.escapeChar = escapeChar;
        this.delegate = delegate;
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        if (this.state == 0) {
            int n = this.state = length > 0 && chars[offset] == '#' ? 2 : 1;
        }
        if (this.state == 1) {
            if (length > 0 && chars[offset] == this.escapeChar) {
                int end = offset + length;
                length = CellUtil.unescapeInPlace(chars, ++offset, end, this.escapeChar) - offset;
            }
            this.delegate.newCell(chars, offset, length);
        }
    }

    @Override
    public boolean endOfRow() {
        if (this.state != 2) {
            this.state = 0;
            return this.delegate.endOfRow();
        }
        this.state = 0;
        return false;
    }

    @Override
    public void end() {
        this.delegate.end();
    }
}

