/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.format.DateTimeParseException;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;

public class MultiDateTimeFormatterConverter<I, O>
implements ContextualConverter<I, O> {
    private final ContextualConverter<I, O>[] converters;

    public MultiDateTimeFormatterConverter(ContextualConverter<I, O>[] converters) {
        this.converters = converters;
    }

    @Override
    public O convert(I in, Context context) throws Exception {
        for (int i = this.converters.length - 1; i >= 0; --i) {
            ContextualConverter<I, O> converter = this.converters[i];
            try {
                return converter.convert(in, context);
            }
            catch (DateTimeParseException dateTimeParseException) {
                continue;
            }
        }
        throw new DateTimeParseException("Unable to parse " + String.valueOf(in), String.valueOf(in), 0);
    }
}

