/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.converter.ComposedConverter;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterFactory;
import org.simpleflatmapper.converter.ConverterFactoryProducer;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.impl.IdentityConverter;
import org.simpleflatmapper.converter.impl.JavaBaseConverterFactoryProducer;
import org.simpleflatmapper.converter.impl.time.JavaTimeConverterFactoryProducer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TypeHelper;

public class ConverterService {
    private static final ConverterService INSTANCE = new ConverterService(ConverterService.getConverterFactories());
    private final List<ConverterFactory> converters;

    private static List<ConverterFactory> getConverterFactories() {
        final ArrayList<ConverterFactory> converterFactories = new ArrayList<ConverterFactory>();
        Consumer factoryConsumer = new Consumer<ConverterFactory<?, ?>>(){

            public void accept(ConverterFactory<?, ?> converterFactory) {
                converterFactories.add(converterFactory);
            }
        };
        new JavaBaseConverterFactoryProducer().produce(factoryConsumer);
        new JavaTimeConverterFactoryProducer().produce(factoryConsumer);
        ProducerServiceLoader.produceFromServiceLoader(ConverterFactoryProducer.class, (Consumer)factoryConsumer);
        return converterFactories;
    }

    public static ConverterService getInstance() {
        return INSTANCE;
    }

    private ConverterService(List<ConverterFactory> converters) {
        this.converters = converters;
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Class<F> inType, Class<P> outType, Object ... params) {
        return this.findConverter((Type)inType, (Type)outType, params);
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Type inType, Type outType, Object ... params) {
        if (TypeHelper.isAssignable((Type)outType, (Type)inType)) {
            return new IdentityConverter();
        }
        List<ScoredConverterFactory> potentials = this.findConverterFactories(inType, outType, params);
        ConvertingTypes targetedTypes = new ConvertingTypes(inType, outType);
        for (ScoredConverterFactory p : potentials) {
            Converter converter = p.converterFactory.newConverter(targetedTypes, params);
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    public List<ScoredConverterFactory> findConverterFactories(Type inType, Type outType, Object ... params) {
        ArrayList<ScoredConverterFactory> potentials = new ArrayList<ScoredConverterFactory>();
        ArrayList<ScoredConverterFactory> tails = new ArrayList<ScoredConverterFactory>();
        ConvertingTypes targetedTypes = new ConvertingTypes(inType, outType);
        for (ConverterFactory converterFactory : this.converters) {
            ConvertingScore score = converterFactory.score(targetedTypes);
            int globalScore = score.getScore();
            if (globalScore >= 0) {
                potentials.add(new ScoredConverterFactory(globalScore, converterFactory));
                continue;
            }
            int tailScore = score.getToScore();
            if (tailScore < 0) continue;
            tails.add(new ScoredConverterFactory(tailScore, converterFactory));
        }
        if (potentials.isEmpty() && tails.size() > 0) {
            Collections.sort(tails);
            int currentScore = Integer.MIN_VALUE;
            block1: for (ScoredConverterFactory sfactory : tails) {
                List<ScoredConverterFactory> tailConverters;
                List<ScoredConverterFactory> headConverters;
                Type tailFactoryInType;
                if (!potentials.isEmpty() && currentScore != Integer.MIN_VALUE) {
                    if (currentScore > sfactory.score) {
                        return potentials;
                    }
                } else {
                    currentScore = sfactory.score;
                }
                if (outType == (tailFactoryInType = sfactory.converterFactory.getFromType()) || (headConverters = this.findConverterFactories(inType, tailFactoryInType, params)).isEmpty() || (tailConverters = this.findConverterFactories(tailFactoryInType, outType, params)).isEmpty()) continue;
                for (ScoredConverterFactory hf : headConverters) {
                    if (hf.converterFactory.newConverter(new ConvertingTypes(inType, tailFactoryInType), params) == null) continue;
                    for (ScoredConverterFactory tf : tailConverters) {
                        if (hf.converterFactory.newConverter(new ConvertingTypes(tailFactoryInType, outType), params) == null) continue;
                        ComposedConverterFactory composedConverterFactory = new ComposedConverterFactory(hf.converterFactory, tf.converterFactory, tailFactoryInType);
                        int score = composedConverterFactory.score(new ConvertingTypes(inType, outType)).getScore();
                        potentials.add(new ScoredConverterFactory(score, composedConverterFactory));
                        continue block1;
                    }
                    continue block1;
                }
            }
        }
        Collections.sort(potentials);
        return potentials;
    }

    private static class ComposedConverterFactory<I, T, O>
    implements ConverterFactory<I, O> {
        private final ConverterFactory<I, T> headConverterFactory;
        private final ConverterFactory<T, O> tailConverterFactory;
        private final Type tType;

        private ComposedConverterFactory(ConverterFactory<I, T> headConverterFactory, ConverterFactory<T, O> tailConverterFactory, Type tType) {
            this.headConverterFactory = headConverterFactory;
            this.tailConverterFactory = tailConverterFactory;
            this.tType = tType;
        }

        @Override
        public Converter<? super I, ? extends O> newConverter(ConvertingTypes targetedTypes, Object ... params) {
            Converter<I, T> head = this.headConverterFactory.newConverter(new ConvertingTypes(targetedTypes.getFrom(), this.tType), params);
            if (head == null) {
                return null;
            }
            Converter<T, O> tail = this.tailConverterFactory.newConverter(new ConvertingTypes(this.tType, targetedTypes.getTo()), new Object[0]);
            if (tail == null) {
                return null;
            }
            return new ComposedConverter<I, T, O>(head, tail);
        }

        @Override
        public ConvertingScore score(ConvertingTypes targetedTypes) {
            ConvertingScore headScore = this.headConverterFactory.score(new ConvertingTypes(targetedTypes.getFrom(), this.tType));
            ConvertingScore tailScore = this.tailConverterFactory.score(new ConvertingTypes(this.tType, targetedTypes.getTo()));
            return new ConvertingScore(Math.min(headScore.getFromScore(), tailScore.getFromScore()), Math.min(headScore.getToScore(), tailScore.getToScore()));
        }

        @Override
        public Type getFromType() {
            return this.headConverterFactory.getFromType();
        }
    }

    private static class ScoredConverterFactory
    implements Comparable<ScoredConverterFactory> {
        private final int score;
        private final ConverterFactory converterFactory;

        private ScoredConverterFactory(int score, ConverterFactory converterFactory) {
            this.score = score;
            this.converterFactory = converterFactory;
        }

        @Override
        public int compareTo(ScoredConverterFactory o) {
            return o.score - this.score;
        }
    }
}

