/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.simpleflatmapper.converter.AbstractConverterFactory;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.impl.time.JavaTimeHelper;
import org.simpleflatmapper.converter.impl.time.MultiDateTimeFormatterConverter;

public abstract class AbstractMultiFormatConverterFactory<I, O>
extends AbstractConverterFactory<I, O> {
    public AbstractMultiFormatConverterFactory(Class<I> from, Class<O> to) {
        super(from, to);
    }

    @Override
    public Converter<? super I, ? extends O> newConverter(ConvertingTypes targetedTypes, Object ... params) {
        DateTimeFormatter[] dateTimeFormatters = JavaTimeHelper.getDateTimeFormatters(params);
        if (dateTimeFormatters.length == 0) {
            return null;
        }
        ZoneId zoneId = JavaTimeHelper.getZoneId(params);
        Converter[] converters = new Converter[dateTimeFormatters.length];
        for (int i = 0; i < dateTimeFormatters.length; ++i) {
            DateTimeFormatter dateTimeFormatter = dateTimeFormatters[i];
            if (dateTimeFormatter.getZone() == null) {
                dateTimeFormatter.withZone(zoneId);
            }
            converters[i] = this.newConverter(dateTimeFormatter);
        }
        if (converters.length == 1) {
            return converters[0];
        }
        return new MultiDateTimeFormatterConverter(converters);
    }

    protected abstract Converter<I, O> newConverter(DateTimeFormatter var1);
}

