/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import org.simpleflatmapper.converter.Converter;

public class ComposedConverter<I, J, O>
implements Converter<I, O> {
    public final Converter<? super I, ? extends J> c1;
    public final Converter<? super J, ? extends O> c2;

    public ComposedConverter(Converter<? super I, ? extends J> c1, Converter<? super J, ? extends O> c2) {
        if (c1 == null || c2 == null) {
            throw new NullPointerException();
        }
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    public O convert(I in) throws Exception {
        return this.c2.convert(this.c1.convert(in));
    }

    public String toString() {
        return "ComposedConverter{c1=" + this.c1 + ", c2=" + this.c2 + '}';
    }

    public int depth() {
        int i = 2;
        if (this.c1 instanceof ComposedConverter) {
            i += ((ComposedConverter)this.c1).depth();
        }
        if (this.c2 instanceof ComposedConverter) {
            i += ((ComposedConverter)this.c2).depth();
        }
        return i;
    }
}

