/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.simpleflatmapper.converter.ComposedConverter;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterFactory;
import org.simpleflatmapper.converter.ConverterFactoryProducer;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.impl.IdentityConverter;
import org.simpleflatmapper.converter.impl.JavaBaseConverterFactoryProducer;
import org.simpleflatmapper.converter.impl.time.JavaTimeConverterFactoryProducer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.TypeHelper;

public class ConverterService {
    private static final ConverterService INSTANCE = new ConverterService(ConverterService.getConverterFactories());
    private final List<ConverterFactory> converters;

    private static List<ConverterFactory> getConverterFactories() {
        return ConverterService.getConverterFactories(ServiceLoader.load(ConverterFactoryProducer.class));
    }

    private static List<ConverterFactory> getConverterFactories(ServiceLoader<ConverterFactoryProducer> serviceLoader) {
        final ArrayList<ConverterFactory> converterFactories = new ArrayList<ConverterFactory>();
        Consumer<ConverterFactory> factoryConsumer = new Consumer<ConverterFactory>(){

            public void accept(ConverterFactory converterFactory) {
                converterFactories.add(converterFactory);
            }
        };
        new JavaBaseConverterFactoryProducer().produce(factoryConsumer);
        new JavaTimeConverterFactoryProducer().produce(factoryConsumer);
        Iterator<ConverterFactoryProducer> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().produce(factoryConsumer);
            }
            catch (Throwable e) {
                System.err.println("Unexpected error on listing ConverterFactoryProducer " + e);
                e.printStackTrace();
            }
        }
        return converterFactories;
    }

    public static ConverterService getInstance() {
        return INSTANCE;
    }

    private ConverterService(List<ConverterFactory> converters) {
        this.converters = converters;
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Class<F> inType, Class<P> outType, Object ... params) {
        return this.findConverter((Type)inType, (Type)outType, params);
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Type inType, Type outType, Object ... params) {
        ArrayList<ScoredConverterFactory> potentials = new ArrayList<ScoredConverterFactory>();
        ArrayList<ScoredConverterFactory> tails = new ArrayList<ScoredConverterFactory>();
        if (TypeHelper.areEquals((Type)inType, (Type)outType)) {
            return new IdentityConverter();
        }
        ConvertingTypes targetedTypes = new ConvertingTypes(inType, outType);
        for (ConverterFactory converterFactory : this.converters) {
            ConvertingScore score = converterFactory.score(targetedTypes);
            int globalScore = score.getScore();
            if (globalScore >= 0) {
                potentials.add(new ScoredConverterFactory(globalScore, converterFactory));
                continue;
            }
            int tailScore = score.getToScore();
            if (tailScore < 0) continue;
            tails.add(new ScoredConverterFactory(tailScore, converterFactory));
        }
        if (potentials.size() > 0) {
            Collections.sort(potentials);
            return ((ScoredConverterFactory)potentials.get(0)).converterFactory.newConverter(targetedTypes, params);
        }
        if (tails.size() > 0) {
            Collections.sort(tails);
            for (ScoredConverterFactory sfactory : tails) {
                Type tailFactoryInType = sfactory.converterFactory.getFromType();
                Converter<F, P> converter = this.findConverter(inType, tailFactoryInType, params);
                if (converter == null) continue;
                return new ComposedConverter(converter, sfactory.converterFactory.newConverter(new ConvertingTypes(tailFactoryInType, targetedTypes.getTo()), params));
            }
        }
        return null;
    }

    private static class ScoredConverterFactory
    implements Comparable<ScoredConverterFactory> {
        private final int score;
        private final ConverterFactory converterFactory;

        private ScoredConverterFactory(int score, ConverterFactory converterFactory) {
            this.score = score;
            this.converterFactory = converterFactory;
        }

        @Override
        public int compareTo(ScoredConverterFactory o) {
            return o.score - this.score;
        }
    }
}

