/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.formatter.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.simple4j.wsclient.exception.SystemException;
import org.simple4j.wsclient.formatter.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFormatter
implements IFormatter {
    private static Logger logger = LoggerFactory.getLogger(SimpleFormatter.class);
    private String beginTokenString = "~!";
    private String endTokenString = "!~";
    private String templateString = "";
    private Map<String, String> inputObjectPropertyToTemplateVariableMapping;

    public String getBeginTokenString() {
        return this.beginTokenString;
    }

    public void setBeginTokenString(String beginTokenString) {
        this.beginTokenString = beginTokenString;
    }

    public String getEndTokenString() {
        return this.endTokenString;
    }

    public void setEndTokenString(String endTokenString) {
        this.endTokenString = endTokenString;
    }

    public String getTemplateString() {
        if (this.templateString == null || this.templateString.trim().length() == 0) {
            throw new SystemException("SimpleFormatter.templateString-empty", "Please set template templateString");
        }
        return this.templateString;
    }

    public void setTemplateString(String templateString) {
        this.templateString = templateString;
    }

    public Map<String, String> getInputObjectPropertyToTemplateVariableMapping() {
        if (this.inputObjectPropertyToTemplateVariableMapping == null || this.inputObjectPropertyToTemplateVariableMapping.size() == 0) {
            throw new SystemException("SimpleFormatter.inputObjectPropertyToTemplateVariableMapping-empty", "Please add a inputObjectPropertyToTemplateVariableMapping from input object to template variables");
        }
        return this.inputObjectPropertyToTemplateVariableMapping;
    }

    public void setInputObjectPropertyToTemplateVariableMapping(Map<String, String> mapping) {
        this.inputObjectPropertyToTemplateVariableMapping = mapping;
    }

    private Map<String, String> mapInputObjectToTemplateVariables(Object arg) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, String> mappedObject = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getInputObjectPropertyToTemplateVariableMapping().entrySet()) {
            mappedObject.put(entry.getKey(), "" + PropertyUtils.getNestedProperty((Object)arg, (String)entry.getValue()));
        }
        return mappedObject;
    }

    @Override
    public String formatData(Object arg) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        logger.info("beginTokenString=" + this.getBeginTokenString());
        logger.info("endTokenString=" + this.getEndTokenString());
        logger.info("templateString=" + this.templateString);
        logger.info("requestData=" + arg);
        String formattedString = new String(this.templateString);
        Map<String, String> newArg = null;
        if (this.getInputObjectPropertyToTemplateVariableMapping() != null && this.getInputObjectPropertyToTemplateVariableMapping().size() > 0) {
            newArg = this.mapInputObjectToTemplateVariables(arg);
            for (Map.Entry<String, String> ent : newArg.entrySet()) {
                if (ent.getValue() == null || ent.getKey() == null || !(ent.getKey() instanceof String)) continue;
                formattedString = formattedString.replace(this.getBeginTokenString() + ent.getKey() + this.getEndTokenString(), ent.getValue());
            }
        }
        logger.info("formatted value=" + formattedString);
        return formattedString;
    }
}

