/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.formatter.impl;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.simple4j.wsclient.formatter.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerFormatter
implements IFormatter {
    private static Logger logger = LoggerFactory.getLogger(FreemarkerFormatter.class);
    private Configuration configuration = null;
    private String templateName = null;
    private String outputEncoding = "UTF-8";

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public String formatData(Object inputObject) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template temp = this.getConfiguration().getTemplate(this.getTemplateName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(baos);
        temp.process(inputObject, (Writer)out);
        return new String(baos.toByteArray(), this.getOutputEncoding());
    }
}

