/*
 * Decompiled with CFR 0.152.
 */
package org.simple.eventbus.matchpolicy;

import java.util.LinkedList;
import java.util.List;
import org.simple.eventbus.EventType;
import org.simple.eventbus.matchpolicy.MatchPolicy;

public class DefaultMatchPolicy
implements MatchPolicy {
    @Override
    public List<EventType> findMatchEventTypes(EventType type, Object aEvent) {
        LinkedList<EventType> result = new LinkedList<EventType>();
        for (Class<?> eventClass = aEvent.getClass(); eventClass != null; eventClass = eventClass.getSuperclass()) {
            result.add(new EventType(eventClass, type.tag));
            this.addInterfaces(result, eventClass, type.tag);
        }
        return result;
    }

    private void addInterfaces(List<EventType> eventTypes, Class<?> eventClass, String tag) {
        Class<?>[] interfacesClasses;
        if (eventClass == null) {
            return;
        }
        for (Class<?> interfaceClass : interfacesClasses = eventClass.getInterfaces()) {
            if (eventTypes.contains(interfaceClass)) continue;
            eventTypes.add(new EventType(interfaceClass, tag));
            this.addInterfaces(eventTypes, interfaceClass, tag);
        }
    }
}

