/*
 * Decompiled with CFR 0.152.
 */
package com.simple.commonadapter.viewholders;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.SparseArray;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;

public class ViewHolderImpl {
    private SparseArray<View> mCahceViews = new SparseArray();
    View mItemView;

    ViewHolderImpl(View itemView) {
        this.mItemView = itemView;
    }

    public View getItemView() {
        return this.mItemView;
    }

    public <T extends View> T findViewById(int viewId) {
        View target = (View)this.mCahceViews.get(viewId);
        if (target == null) {
            target = this.mItemView.findViewById(viewId);
            this.mCahceViews.put(viewId, (Object)target);
        }
        return (T)target;
    }

    public void setText(int viewId, int stringId) {
        TextView textView = (TextView)this.findViewById(viewId);
        textView.setText(stringId);
    }

    public void setText(int viewId, String text) {
        TextView textView = (TextView)this.findViewById(viewId);
        textView.setText((CharSequence)text);
    }

    public void setTextColor(int viewId, int color) {
        TextView textView = (TextView)this.findViewById(viewId);
        textView.setTextColor(color);
    }

    public void setBackgroundColor(int viewId, int color) {
        Object target = this.findViewById(viewId);
        target.setBackgroundColor(color);
    }

    public void setBackgroundResource(int viewId, int resId) {
        Object target = this.findViewById(viewId);
        target.setBackgroundResource(resId);
    }

    public void setBackgroundDrawable(int viewId, Drawable drawable) {
        Object target = this.findViewById(viewId);
        target.setBackgroundDrawable(drawable);
    }

    @TargetApi(value=16)
    public void setBackground(int viewId, Drawable drawable) {
        Object target = this.findViewById(viewId);
        target.setBackground(drawable);
    }

    public void setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView target = (ImageView)this.findViewById(viewId);
        target.setImageBitmap(bitmap);
    }

    public void setImageResource(int viewId, int resId) {
        ImageView target = (ImageView)this.findViewById(viewId);
        target.setImageResource(resId);
    }

    public void setImageDrawable(int viewId, Drawable drawable) {
        ImageView target = (ImageView)this.findViewById(viewId);
        target.setImageDrawable(drawable);
    }

    public void setImageDrawable(int viewId, Uri uri) {
        ImageView target = (ImageView)this.findViewById(viewId);
        target.setImageURI(uri);
    }

    @TargetApi(value=16)
    public void setImageAlpha(int viewId, int alpha) {
        ImageView target = (ImageView)this.findViewById(viewId);
        target.setImageAlpha(alpha);
    }

    public void setChecked(int viewId, boolean checked) {
        Checkable checkable = (Checkable)this.findViewById(viewId);
        checkable.setChecked(checked);
    }

    public void setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.findViewById(viewId);
        view.setProgress(progress);
    }

    public void setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.findViewById(viewId);
        view.setMax(max);
        view.setProgress(progress);
    }

    public void setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.findViewById(viewId);
        view.setMax(max);
    }

    public void setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.findViewById(viewId);
        view.setRating(rating);
    }

    public void setVisibility(int viewId, int visible) {
        Object view = this.findViewById(viewId);
        view.setVisibility(visible);
    }

    public void setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.findViewById(viewId);
        view.setMax(max);
        view.setRating(rating);
    }

    public void setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.findViewById(viewId);
        view.setOnClickListener(listener);
    }

    public void setOnTouchListener(int viewId, View.OnTouchListener listener) {
        Object view = this.findViewById(viewId);
        view.setOnTouchListener(listener);
    }

    public void setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.findViewById(viewId);
        view.setOnLongClickListener(listener);
    }

    public void setOnItemClickListener(int viewId, AdapterView.OnItemClickListener listener) {
        AdapterView view = (AdapterView)this.findViewById(viewId);
        view.setOnItemClickListener(listener);
    }

    public void setOnItemLongClickListener(int viewId, AdapterView.OnItemLongClickListener listener) {
        AdapterView view = (AdapterView)this.findViewById(viewId);
        view.setOnItemLongClickListener(listener);
    }

    public void setOnItemSelectedClickListener(int viewId, AdapterView.OnItemSelectedListener listener) {
        AdapterView view = (AdapterView)this.findViewById(viewId);
        view.setOnItemSelectedListener(listener);
    }
}

