/*
 * Decompiled with CFR 0.152.
 */
package com.simple.commonadapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.simple.commonadapter.viewholders.RecyclerViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerAdapter<D>
extends RecyclerView.Adapter<RecyclerViewHolder> {
    protected final List<D> mDataSet = new ArrayList<D>();
    protected OnItemClickListener mOnItemClickListener;
    private int mItemLayoutId;

    public RecyclerAdapter(int layoutId) {
        this.mItemLayoutId = layoutId;
    }

    public RecyclerAdapter(int layoutId, List<D> datas) {
        this.mItemLayoutId = layoutId;
        this.addItems(datas);
    }

    public void addItem(D item) {
        this.mDataSet.add(item);
        this.notifyDataSetChanged();
    }

    public void addItems(List<D> items) {
        this.mDataSet.addAll(items);
        this.notifyDataSetChanged();
    }

    public void addItemToHead(D item) {
        this.mDataSet.add(0, item);
        this.notifyDataSetChanged();
    }

    public void addItemsToHead(List<D> items) {
        this.mDataSet.addAll(0, items);
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.mDataSet.remove(position);
        this.notifyDataSetChanged();
    }

    public void remove(D item) {
        this.mDataSet.remove(item);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mDataSet.clear();
        this.notifyDataSetChanged();
    }

    public D getItem(int position) {
        return this.mDataSet.get(position);
    }

    public int getItemCount() {
        return this.mDataSet.size();
    }

    public void onBindViewHolder(RecyclerViewHolder holder, int position) {
        D item = this.getItem(position);
        this.onBindData(holder, position, item);
        this.setupItemClickListener(holder, position);
    }

    protected View inflateItemView(ViewGroup viewGroup, int viewType) {
        int itemLayout = this.getItemLayout(viewType);
        Context context = viewGroup.getContext();
        return LayoutInflater.from((Context)context).inflate(itemLayout, viewGroup, false);
    }

    public RecyclerViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new RecyclerViewHolder(this.inflateItemView(parent, viewType));
    }

    protected int getItemLayout(int type) {
        return this.mItemLayoutId;
    }

    protected abstract void onBindData(RecyclerViewHolder var1, int var2, D var3);

    protected void setupItemClickListener(RecyclerViewHolder viewHolder, final int position) {
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RecyclerAdapter.this.mOnItemClickListener != null) {
                    RecyclerAdapter.this.mOnItemClickListener.onItemClick(position);
                }
            }
        });
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

