/*
 * Decompiled with CFR 0.152.
 */
package com.simple.commonadapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.simple.commonadapter.viewholders.GodViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class ListViewAdapter<D>
extends BaseAdapter {
    protected final List<D> mDataSet = new ArrayList<D>();
    private int mItemLayoutId;

    public ListViewAdapter(int layoutId) {
        this.mItemLayoutId = layoutId;
    }

    public ListViewAdapter(int layoutId, List<D> datas) {
        this.mItemLayoutId = layoutId;
        this.mDataSet.addAll(datas);
    }

    public void addItem(D item) {
        this.mDataSet.add(item);
        this.notifyDataSetChanged();
    }

    public void addItems(List<D> items) {
        this.mDataSet.addAll(items);
        this.notifyDataSetChanged();
    }

    public void addItemToHead(D item) {
        this.mDataSet.add(0, item);
        this.notifyDataSetChanged();
    }

    public void addItemsToHead(List<D> items) {
        this.mDataSet.addAll(0, items);
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.mDataSet.remove(position);
        this.notifyDataSetChanged();
    }

    public void remove(D item) {
        this.mDataSet.remove(item);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mDataSet.size();
    }

    public D getItem(int position) {
        return this.mDataSet.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    protected int getItemLayout(int type) {
        return this.mItemLayoutId;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int viewType = this.getItemViewType(position);
        GodViewHolder viewHolder = GodViewHolder.get(convertView, parent, this.getItemLayout(viewType));
        this.onBindData(viewHolder, position, this.getItem(position));
        return viewHolder.getItemView();
    }

    protected abstract void onBindData(GodViewHolder var1, int var2, D var3);
}

