/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search.internal;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.sikuli.core.logging.ImageExplainer;

public class TemplateMatchingUtilities {
    static ImageExplainer explainer = ImageExplainer.getExplainer(TemplateMatchingUtilities.class);

    public static opencv_core.IplImage computeTemplateMatchResultMatrix(opencv_core.IplImage input, opencv_core.IplImage target) {
        int iheight;
        int iwidth;
        if (input.roi() != null) {
            iwidth = input.roi().width() - target.width() + 1;
            iheight = input.roi().height() - target.height() + 1;
        } else {
            iwidth = input.width() - target.width() + 1;
            iheight = input.height() - target.height() + 1;
        }
        opencv_core.IplImage map = opencv_core.IplImage.create((opencv_core.CvSize)opencv_core.cvSize((int)iwidth, (int)iheight), (int)32, (int)1);
        opencv_imgproc.cvMatchTemplate((opencv_core.CvArr)input, (opencv_core.CvArr)target, (opencv_core.CvArr)map, (int)5);
        return map;
    }

    static BufferedImage visualizeResultMatrix(opencv_core.IplImage result) {
        opencv_core.IplImage resultToShow = opencv_core.IplImage.create((opencv_core.CvSize)opencv_core.cvGetSize((opencv_core.CvArr)result), (int)8, (int)1);
        opencv_core.cvConvertScale((opencv_core.CvArr)result, (opencv_core.CvArr)resultToShow, (double)255.0, (double)0.0);
        return resultToShow.getBufferedImage();
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrixWithMultipleROIs(opencv_core.IplImage input, opencv_core.IplImage target, List<Rectangle> ROIs) {
        opencv_core.cvResetImageROI((opencv_core.IplImage)input);
        int iwidth = input.width() - target.width() + 1;
        int iheight = input.height() - target.height() + 1;
        opencv_core.IplImage result = opencv_core.IplImage.create((opencv_core.CvSize)opencv_core.cvSize((int)iwidth, (int)iheight), (int)32, (int)1);
        opencv_core.cvSet((opencv_core.CvArr)result, (opencv_core.CvScalar)opencv_core.cvScalarAll((double)0.0));
        for (Rectangle unboundedROI : ROIs) {
            if (unboundedROI.width < target.width() || unboundedROI.height < target.height()) continue;
            Rectangle roi = unboundedROI.intersection(new Rectangle(0, 0, input.width(), input.height()));
            opencv_core.cvSetImageROI((opencv_core.IplImage)input, (opencv_core.CvRect)opencv_core.cvRect((int)roi.x, (int)roi.y, (int)roi.width, (int)roi.height));
            int w = roi.width - target.width() + 1;
            int h = roi.height - target.height() + 1;
            opencv_core.cvSetImageROI((opencv_core.IplImage)result, (opencv_core.CvRect)opencv_core.cvRect((int)roi.x, (int)roi.y, (int)w, (int)h));
            opencv_imgproc.cvMatchTemplate((opencv_core.CvArr)input, (opencv_core.CvArr)target, (opencv_core.CvArr)result, (int)5);
            opencv_core.cvResetImageROI((opencv_core.IplImage)result);
            opencv_core.cvResetImageROI((opencv_core.IplImage)input);
        }
        explainer.result(TemplateMatchingUtilities.visualizeResultMatrix(result), (Object)"result with faster implementation");
        return result;
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrixWithMultipleROIs_GrouthTruth(opencv_core.IplImage input, opencv_core.IplImage target, List<Rectangle> ROIs) {
        opencv_core.cvResetImageROI((opencv_core.IplImage)input);
        int iwidth = input.width() - target.width() + 1;
        int iheight = input.height() - target.height() + 1;
        explainer.step(input, (Object)"input");
        opencv_core.IplImage result = opencv_core.IplImage.create((opencv_core.CvSize)opencv_core.cvSize((int)iwidth, (int)iheight), (int)32, (int)1);
        opencv_imgproc.cvMatchTemplate((opencv_core.CvArr)input, (opencv_core.CvArr)target, (opencv_core.CvArr)result, (int)5);
        explainer.step(TemplateMatchingUtilities.visualizeResultMatrix(result), (Object)"raw result");
        opencv_core.IplImage keepMask = opencv_core.IplImage.create((opencv_core.CvSize)opencv_core.cvSize((int)iwidth, (int)iheight), (int)8, (int)1);
        opencv_core.cvSet((opencv_core.CvArr)keepMask, (opencv_core.CvScalar)opencv_core.cvScalarAll((double)0.0));
        for (Rectangle ROI : ROIs) {
            if (ROI.width < target.width() || ROI.height < target.height()) continue;
            int w = Math.min(ROI.width, iwidth - ROI.x);
            int h = Math.min(ROI.height, iheight - ROI.y);
            w = w - target.width() + 1;
            h = h - target.height() + 1;
            opencv_core.CvRect cvROI = opencv_core.cvRect((int)ROI.x, (int)ROI.y, (int)w, (int)h);
            opencv_core.cvSetImageROI((opencv_core.IplImage)keepMask, (opencv_core.CvRect)cvROI);
            opencv_core.cvSet((opencv_core.CvArr)keepMask, (opencv_core.CvScalar)opencv_core.cvScalarAll((double)255.0));
            opencv_core.cvResetImageROI((opencv_core.IplImage)keepMask);
        }
        explainer.step(keepMask, (Object)"keep mask");
        opencv_core.IplImage maskedResult = opencv_core.IplImage.createCompatible((opencv_core.IplImage)result);
        opencv_core.cvSet((opencv_core.CvArr)maskedResult, (opencv_core.CvScalar)opencv_core.cvScalarAll((double)0.0));
        opencv_core.cvCopy((opencv_core.CvArr)result, (opencv_core.CvArr)maskedResult, (opencv_core.CvArr)keepMask);
        explainer.result(TemplateMatchingUtilities.visualizeResultMatrix(maskedResult), (Object)"match result with only ROIs");
        maskedResult.release();
        keepMask.release();
        return result;
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrix1(opencv_core.IplImage input, opencv_core.IplImage target) {
        int iheight;
        int iwidth;
        if (input.roi() != null) {
            iwidth = input.roi().width() - target.width() + 1;
            iheight = input.roi().height() - target.height() + 1;
        } else {
            iwidth = input.width() - target.width() + 1;
            iheight = input.height() - target.height() + 1;
        }
        opencv_core.IplImage map = opencv_core.IplImage.create((opencv_core.CvSize)opencv_core.cvSize((int)iwidth, (int)iheight), (int)32, (int)1);
        opencv_imgproc.cvMatchTemplate((opencv_core.CvArr)input, (opencv_core.CvArr)target, (opencv_core.CvArr)map, (int)1);
        return map;
    }

    public static TemplateMatchResult fetchNextBestMatch1(opencv_core.IplImage resultMatrix, opencv_core.IplImage target) {
        DoublePointer min = new DoublePointer(1);
        DoublePointer max = new DoublePointer(1);
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)resultMatrix, (DoublePointer)min, (DoublePointer)max, (opencv_core.CvPoint)minPoint, (opencv_core.CvPoint)maxPoint, null);
        double detectionScore = min.get(0);
        opencv_core.CvPoint detectionLoc = minPoint;
        TemplateMatchResult r = new TemplateMatchResult();
        r.x = detectionLoc.x();
        r.y = detectionLoc.y();
        r.width = target.width();
        r.height = target.height();
        r.score = detectionScore;
        int xmargin = target.width() / 3;
        int ymargin = target.height() / 3;
        int x = detectionLoc.x();
        int y = detectionLoc.y();
        int x0 = Math.max(x - xmargin, 0);
        int y0 = Math.max(y - ymargin, 0);
        int x1 = Math.min(x + xmargin, resultMatrix.width());
        int y1 = Math.min(y + ymargin, resultMatrix.height());
        opencv_core.cvRectangle((opencv_core.CvArr)resultMatrix, (opencv_core.CvPoint)opencv_core.cvPoint((int)x0, (int)y0), (opencv_core.CvPoint)opencv_core.cvPoint((int)(x1 - 1), (int)(y1 - 1)), (opencv_core.CvScalar)opencv_core.cvRealScalar((double)1.0), (int)-1, (int)8, (int)0);
        return r;
    }

    public static TemplateMatchResult fetchNextBestMatch(opencv_core.IplImage resultMatrix, opencv_core.IplImage target) {
        DoublePointer min = new DoublePointer(1);
        DoublePointer max = new DoublePointer(1);
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)resultMatrix, (DoublePointer)min, (DoublePointer)max, (opencv_core.CvPoint)minPoint, (opencv_core.CvPoint)maxPoint, null);
        double detectionScore = max.get(0);
        opencv_core.CvPoint detectionLoc = maxPoint;
        TemplateMatchResult r = new TemplateMatchResult();
        r.x = detectionLoc.x();
        r.y = detectionLoc.y();
        r.width = target.width();
        r.height = target.height();
        r.score = detectionScore;
        int xmargin = target.width() / 3;
        int ymargin = target.height() / 3;
        int x = detectionLoc.x();
        int y = detectionLoc.y();
        int x0 = Math.max(x - xmargin, 0);
        int y0 = Math.max(y - ymargin, 0);
        int x1 = Math.min(x + xmargin, resultMatrix.width());
        int y1 = Math.min(y + ymargin, resultMatrix.height());
        opencv_core.cvRectangle((opencv_core.CvArr)resultMatrix, (opencv_core.CvPoint)opencv_core.cvPoint((int)x0, (int)y0), (opencv_core.CvPoint)opencv_core.cvPoint((int)(x1 - 1), (int)(y1 - 1)), (opencv_core.CvScalar)opencv_core.cvRealScalar((double)0.0), (int)-1, (int)8, (int)0);
        return r;
    }

    public static class TemplateMatchResult
    extends Rectangle {
        public double score;
    }
}

