/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.draw;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PShadow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.sikuli.core.cv.VisionUtils;
import org.sikuli.core.draw.ImageRenderer;

public abstract class PiccoloImageRenderer
implements ImageRenderer {
    private final BufferedImage input;

    public PiccoloImageRenderer(BufferedImage input) {
        this.input = input;
    }

    public PiccoloImageRenderer(int width, int height) {
        this.input = new BufferedImage(width, height, 2);
    }

    public static void addNodeWithShadow(PNode parent, PNode node) {
        int blurRadius = 4;
        PShadow shadowNode = new PShadow(node.toImage(), (Paint)Color.gray, blurRadius);
        double tx = node.getX() + node.getXOffset();
        double ty = node.getY() + node.getYOffset();
        shadowNode.setOffset(tx - (double)(2 * blurRadius) + 1.0, ty - (double)(2 * blurRadius) + 1.0);
        parent.addChild((PNode)shadowNode);
        parent.addChild(node);
    }

    @Override
    public BufferedImage render() {
        PCanvas canvas = new PCanvas();
        PImage image = new PImage((Image)this.input);
        canvas.getLayer().addChild((PNode)image);
        this.addContent(canvas.getLayer());
        canvas.setBounds(0, 0, this.input.getWidth(), this.input.getHeight());
        return VisionUtils.createComponentImage((Component)canvas);
    }

    protected abstract void addContent(PLayer var1);
}

