/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.draw;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.sikuli.core.draw.PiccoloImageRenderer;

public class BlobPainter
extends PiccoloImageRenderer {
    final List<opencv_core.CvRect> blobs;

    public BlobPainter(BufferedImage input, List<opencv_core.CvRect> blobs) {
        super(input);
        this.blobs = blobs;
    }

    @Override
    protected void addContent(PLayer layer) {
        for (opencv_core.CvRect blob : this.blobs) {
            PPath rect = PPath.createRectangle((float)blob.x(), (float)blob.y(), (float)blob.width(), (float)blob.height());
            Random numGen = new Random();
            Color randomColor = new Color(numGen.nextInt(256), numGen.nextInt(256), numGen.nextInt(256));
            rect.setStrokePaint((Paint)Color.cyan);
            rect.setStroke((Stroke)new BasicStroke(5.0f));
            rect.setPaint(null);
            layer.addChild((PNode)rect);
            PText sizeText = new PText("" + blob.width() + "x" + blob.height());
            sizeText.setOffset((double)blob.x(), (double)blob.y());
            sizeText.setHorizontalAlignment(0.0f);
            sizeText.setPaint((Paint)Color.black);
            sizeText.setTextPaint((Paint)Color.white);
            layer.addChild((PNode)sizeText);
        }
    }
}

