/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.helper.opencv_imgproc;
import org.bytedeco.javacpp.opencv_core;
import org.sikuli.core.draw.BlobPainter;
import org.sikuli.core.logging.ImageExplainer;

public class VisionUtils {
    static ImageExplainer explainer = ImageExplainer.getExplainer(VisionUtils.class);

    public static BufferedImage createComponentImage(Component component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    public static List<opencv_core.CvRect> detectBlobs(opencv_core.IplImage input) {
        opencv_core.CvSeq contour;
        opencv_core.IplImage clone = input.clone();
        opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
        opencv_imgproc.cvFindContours((opencv_core.CvArr)clone, (opencv_core.CvMemStorage)storage, (opencv_core.CvSeq)contour, (int)Loader.sizeof(opencv_core.CvContour.class), (int)0, (int)2);
        ArrayList rects = Lists.newArrayList();
        for (contour = new opencv_core.CvSeq(null); contour != null && !contour.isNull(); contour = contour.h_next()) {
            if (contour.elem_size() <= 0) continue;
            opencv_core.CvRect boundingRect = org.bytedeco.javacpp.opencv_imgproc.cvBoundingRect((opencv_core.CvArr)contour, (int)0);
            rects.add(boundingRect);
        }
        return rects;
    }

    public static BufferedImage createImageFrom(Component component) {
        Dimension size = component.getPreferredSize();
        if (size.width == 0 || size.height == 0) {
            size = component.getSize();
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    public static void negate(opencv_core.IplImage src, opencv_core.IplImage dest) {
        org.bytedeco.javacpp.opencv_core.cvSubRS((opencv_core.CvArr)src, (opencv_core.CvScalar)org.bytedeco.javacpp.opencv_core.cvScalarAll((double)255.0), (opencv_core.CvArr)dest, null);
    }

    public static opencv_core.IplImage createGrayImageFrom(opencv_core.IplImage input) {
        if (input.nChannels() == 3) {
            opencv_core.IplImage gray = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)input), (int)8, (int)1);
            org.bytedeco.javacpp.opencv_imgproc.cvCvtColor((opencv_core.CvArr)input, (opencv_core.CvArr)gray, (int)6);
            return gray;
        }
        if (input.nChannels() == 4) {
            opencv_core.IplImage gray = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)input), (int)8, (int)1);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI((opencv_core.IplImage)input, (int)3);
            org.bytedeco.javacpp.opencv_core.cvCopy((opencv_core.CvArr)input, (opencv_core.CvArr)gray);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI((opencv_core.IplImage)input, (int)0);
            return gray;
        }
        if (input.nChannels() == 2) {
            opencv_core.IplImage gray = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)input), (int)8, (int)1);
            opencv_core.IplImage alpha = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)input), (int)8, (int)1);
            opencv_core.IplImage white = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)input), (int)8, (int)1);
            org.bytedeco.javacpp.opencv_core.cvSet((opencv_core.CvArr)white, (opencv_core.CvScalar)opencv_core.CvScalar.WHITE);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI((opencv_core.IplImage)input, (int)1);
            org.bytedeco.javacpp.opencv_core.cvCopy((opencv_core.CvArr)input, (opencv_core.CvArr)gray);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI((opencv_core.IplImage)input, (int)2);
            org.bytedeco.javacpp.opencv_core.cvCopy((opencv_core.CvArr)input, (opencv_core.CvArr)alpha);
            org.bytedeco.javacpp.opencv_core.cvCopy((opencv_core.CvArr)gray, (opencv_core.CvArr)white, (opencv_core.CvArr)alpha);
            return white;
        }
        return input;
    }

    public static opencv_core.IplImage computeForegroundMaskOf(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)grayImage), (int)8, (int)1);
        org.bytedeco.javacpp.opencv_imgproc.cvCanny((opencv_core.CvArr)grayImage, (opencv_core.CvArr)foregroundMask, (double)33.0, (double)66.5, (int)3);
        opencv_core.IplConvKernel kernel = opencv_core.IplConvKernel.create((int)3, (int)3, (int)1, (int)1, (int)0, null);
        org.bytedeco.javacpp.opencv_imgproc.cvDilate((opencv_core.CvArr)foregroundMask, (opencv_core.CvArr)foregroundMask, (opencv_core.IplConvKernel)kernel, (int)2);
        kernel.release();
        return foregroundMask;
    }

    public static opencv_core.IplImage computeEdges(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)grayImage), (int)8, (int)1);
        org.bytedeco.javacpp.opencv_imgproc.cvCanny((opencv_core.CvArr)grayImage, (opencv_core.CvArr)foregroundMask, (double)33.0, (double)66.5, (int)3);
        return foregroundMask;
    }

    public static opencv_core.IplImage getForeground(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)grayImage), (int)8, (int)1);
        opencv_core.IplImage foreground = opencv_core.IplImage.create((opencv_core.CvSize)org.bytedeco.javacpp.opencv_core.cvGetSize((opencv_core.CvArr)inputImage), (int)8, (int)3);
        org.bytedeco.javacpp.opencv_imgproc.cvCanny((opencv_core.CvArr)grayImage, (opencv_core.CvArr)foregroundMask, (double)33.0, (double)66.5, (int)3);
        opencv_core.IplConvKernel kernel = opencv_core.IplConvKernel.create((int)3, (int)3, (int)1, (int)1, (int)0, null);
        org.bytedeco.javacpp.opencv_imgproc.cvDilate((opencv_core.CvArr)foregroundMask, (opencv_core.CvArr)foregroundMask, (opencv_core.IplConvKernel)kernel, (int)1);
        kernel.release();
        org.bytedeco.javacpp.opencv_core.cvSet((opencv_core.CvArr)foreground, (opencv_core.CvScalar)org.bytedeco.javacpp.opencv_core.cvScalarAll((double)255.0));
        org.bytedeco.javacpp.opencv_core.cvCopy((opencv_core.CvArr)inputImage, (opencv_core.CvArr)foreground, (opencv_core.CvArr)foregroundMask);
        return foreground;
    }

    public static BufferedImage paintBlobsOnImage(BufferedImage image, List<opencv_core.CvRect> blobs) {
        return new BlobPainter(image, blobs).render();
    }

    public static opencv_core.IplImage cloneWithoutAlphaChannel(opencv_core.IplImage bgra) {
        opencv_core.IplImage bgr = opencv_core.IplImage.create((int)bgra.width(), (int)bgra.height(), (int)8, (int)3);
        opencv_core.IplImage alpha = opencv_core.IplImage.create((int)bgra.width(), (int)bgra.height(), (int)8, (int)1);
        opencv_core.IplImage[] in = new opencv_core.IplImage[]{bgra};
        opencv_core.IplImage[] out = new opencv_core.IplImage[]{bgr, alpha};
        int[] from_to = new int[]{0, 3, 1, 0, 2, 1, 3, 2};
        opencv_core.cvMixChannels((opencv_core.CvArr[])in, (int)1, (opencv_core.CvArr[])out, (int)2, (int[])from_to, (int)4);
        return bgr;
    }
}

