/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PShadow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import org.sikuli.api.visual.element.BoxElement;
import org.sikuli.api.visual.element.CircleElement;
import org.sikuli.api.visual.element.DotElement;
import org.sikuli.api.visual.element.Element;
import org.sikuli.api.visual.element.ImageElement;
import org.sikuli.api.visual.element.LabelElement;
import org.sikuli.api.visual.element.RefreshableImageElement;

class PNodeFactory {
    private static final Color SHADOW_PAINT = new Color(10, 10, 10, 255);

    PNodeFactory() {
    }

    public static PNode createFrom(Element element) {
        Class<?> clazz = element.getClass();
        if (clazz == LabelElement.class) {
            return PNodeFactory.createFrom((LabelElement)element);
        }
        if (clazz == BoxElement.class) {
            return PNodeFactory.createFrom((BoxElement)element);
        }
        if (clazz == CircleElement.class) {
            return PNodeFactory.createFrom((CircleElement)element);
        }
        if (clazz == ImageElement.class) {
            return PNodeFactory.createFrom((ImageElement)element);
        }
        if (clazz == DotElement.class) {
            return PNodeFactory.createFrom((DotElement)element);
        }
        if (clazz == RefreshableImageElement.class) {
            return PNodeFactory.createFrom((RefreshableImageElement)element);
        }
        return new PNode();
    }

    public static PNode createFrom(LabelElement element) {
        final PText txt = new PText(element.getText());
        txt.setTextPaint((Paint)Color.black);
        txt.setPaint((Paint)element.getBackgroundColor());
        txt.setTextPaint((Paint)element.getColor());
        txt.setFont(txt.getFont().deriveFont(element.getFontSize()));
        PNode labelNode = new PNode();
        labelNode.setPaint((Paint)element.getBackgroundColor());
        labelNode.addChild((PNode)txt);
        labelNode.setHeight(txt.getHeight() + 2.0);
        labelNode.setWidth(txt.getWidth() + 4.0);
        txt.setOffset(2.0, 1.0);
        element.addListener(new LabelElement.Listener(){

            @Override
            public void textUpdated(String newText) {
                txt.setText(newText);
                txt.repaint();
            }
        });
        PNodeFactory.applyAlignment(labelNode, element);
        return PNodeFactory.applyTransparencyAndShadow(labelNode, element);
    }

    public static PNode createFrom(DotElement element) {
        PPath p = PPath.createEllipse((float)0.0f, (float)0.0f, (float)4.0f, (float)4.0f);
        p.setStrokePaint((Paint)element.getColor());
        p.setPaint((Paint)element.getColor());
        p.setStroke((Stroke)new BasicStroke(element.getLineWidth()));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild((PNode)p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset((double)(element.x - 2), (double)(element.y - 2));
        PNode node = PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
        return node;
    }

    public static PNode createFrom(CircleElement element) {
        PPath p = PPath.createEllipse((float)0.0f, (float)0.0f, (float)element.width, (float)element.height);
        p.setStrokePaint((Paint)element.getLineColor());
        p.setPaint(null);
        p.setStroke((Stroke)new BasicStroke(element.getLineWidth()));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild((PNode)p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset((double)element.x, (double)element.y);
        return PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
    }

    public static PNode createFrom(BoxElement element) {
        PPath p = PPath.createRectangle((float)0.0f, (float)0.0f, (float)element.width, (float)element.height);
        p.setStrokePaint((Paint)element.getLineColor());
        p.setPaint((Paint)element.getBackgroundColor());
        p.setStroke((Stroke)new BasicStroke(element.getLineWidth()));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild((PNode)p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset((double)element.x, (double)element.y);
        return PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
    }

    public static PNode createFrom(ImageElement element) {
        final PImage p = new PImage((Image)element.getImage());
        PNode foregroundNode = new PNode();
        foregroundNode.addChild((PNode)p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset((double)element.x, (double)element.y);
        element.addListener(new ImageElement.Listener(){

            @Override
            public void imageUpdated(BufferedImage newImage) {
                p.setImage((Image)newImage);
                p.repaint();
            }
        });
        PNodeFactory.applyAlignment(foregroundNode, element);
        return foregroundNode;
    }

    private static void applyAlignment(PNode node, Element element) {
        double width = node.getWidth();
        double height = node.getHeight();
        double x = element.x;
        double y = element.y;
        if (element.verticalAlignment == Element.VerticalAlignment.TOP) {
            y = element.y;
        } else if (element.verticalAlignment == Element.VerticalAlignment.MIDDLE) {
            y = (double)element.y - height / 2.0;
        } else if (element.verticalAlignment == Element.VerticalAlignment.BOTTOM) {
            y = (double)element.y - height;
        }
        if (element.horizontalAlignment == Element.HorizontalAlignment.RIGHT) {
            x = (double)element.x - width;
        } else if (element.horizontalAlignment == Element.HorizontalAlignment.LEFT) {
            x = element.x;
        } else if (element.horizontalAlignment == Element.HorizontalAlignment.CENTER) {
            x = (double)element.x - width / 2.0;
        }
        node.setOffset(x, y);
    }

    private static PNode applyTransparencyAndShadow(PNode node, Element element) {
        PNode shadowedNode = PNodeFactory.addShadow(node);
        shadowedNode.setTransparency(element.getTransparency());
        return shadowedNode;
    }

    private static PNode addShadow(PNode contentNode) {
        PNode contentNodeWithShadow = new PNode();
        double xoffset = contentNode.getXOffset();
        double yoffset = contentNode.getYOffset();
        int blurRadius = 4;
        int tx = 5;
        int ty = 5;
        PShadow shadowNode = new PShadow(contentNode.toImage(), (Paint)SHADOW_PAINT, blurRadius);
        contentNode.setOffset((double)tx, (double)ty);
        shadowNode.setOffset((double)(tx - 2 * blurRadius) + 1.0, (double)(ty - 2 * blurRadius) + 1.0);
        contentNodeWithShadow.addChild((PNode)shadowNode);
        contentNodeWithShadow.addChild(contentNode);
        contentNodeWithShadow.setOffset(xoffset - (double)tx, yoffset - (double)ty);
        contentNodeWithShadow.setBounds(0.0, 0.0, contentNode.getWidth() + (double)(2 * blurRadius) + (double)tx, contentNode.getHeight() + (double)(2 * blurRadius) + (double)ty);
        return contentNodeWithShadow;
    }
}

