/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import org.sikuli.api.ScreenLocation;
import org.sikuli.api.robot.Mouse;
import org.sikuli.api.robot.desktop.AWTDesktop;
import org.sikuli.api.robot.desktop.AWTMouse;

public class DesktopMouse
implements Mouse {
    private AWTMouse getAWTMouse(ScreenLocation screenLoc) {
        return AWTDesktop.getMouse(screenLoc);
    }

    private AWTMouse getCurrentAWTMouse() {
        return AWTDesktop.getCurrentMouse();
    }

    @Override
    public void hover(ScreenLocation dest) {
        AWTMouse srcMouse = this.getCurrentAWTMouse();
        AWTMouse destMouse = this.getAWTMouse(dest);
        if (destMouse != srcMouse) {
            destMouse.move(dest);
        } else {
            ScreenLocation src = this.getLocation();
            srcMouse.smoothMove(src, dest, 500);
        }
    }

    @Override
    public void move(ScreenLocation dest) {
        this.getAWTMouse(dest).move(dest);
    }

    @Override
    public void drag(ScreenLocation screenLoc) {
        this.hover(screenLoc);
        this.getAWTMouse(screenLoc).drag();
    }

    @Override
    public void drop(ScreenLocation screenLoc) {
        this.hover(screenLoc);
        this.getAWTMouse(screenLoc).drop();
    }

    @Override
    public void rightClick(ScreenLocation screenLoc) {
        this.hover(screenLoc);
        this.getAWTMouse(screenLoc).rightClick();
    }

    @Override
    public void doubleClick(ScreenLocation screenLoc) {
        this.hover(screenLoc);
        this.getAWTMouse(screenLoc).doubleClick();
    }

    @Override
    public void click(ScreenLocation screenLoc) {
        if (screenLoc != null) {
            this.hover(screenLoc);
            this.getAWTMouse(screenLoc).click();
        }
    }

    @Override
    public void press() {
        this.getCurrentAWTMouse().mouseDown(16);
    }

    @Override
    public void rightPress() {
        this.getCurrentAWTMouse().mouseDown(4);
    }

    @Override
    public void release() {
        this.getCurrentAWTMouse().mouseUp(16);
    }

    @Override
    public void rightRelease() {
        this.getCurrentAWTMouse().mouseUp(4);
    }

    @Override
    public void wheel(int direction, int steps) {
        this.getCurrentAWTMouse().wheel(direction, steps);
    }

    @Override
    public void mouseDown(int buttons) {
        this.getCurrentAWTMouse().mouseDown(buttons);
    }

    @Override
    public void mouseUp() {
        this.getCurrentAWTMouse().mouseUp(0);
    }

    @Override
    public void mouseUp(int buttons) {
        this.getCurrentAWTMouse().mouseUp(buttons);
    }

    @Override
    public ScreenLocation getLocation() {
        return AWTDesktop.getCurrentMouseScreenLocation();
    }
}

