/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import com.google.common.base.Preconditions;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.Env;
import org.sikuli.api.robot.Keyboard;
import org.sikuli.api.robot.desktop.AWTDesktop;
import org.sikuli.api.robot.desktop.AWTRobot;
import org.sikuli.api.robot.desktop.Clipboard;
import org.sikuli.api.robot.desktop.DesktopMouse;

public class DesktopKeyboard
implements Keyboard {
    private static int modifiers;
    private static String _hold_keys;

    private static AWTRobot getRobot() {
        return AWTDesktop.getCurrentRobot();
    }

    @Override
    public String copy() {
        Clipboard.clear();
        int mod = Env.getHotkeyModifier();
        AWTRobot robot = DesktopKeyboard.getRobot();
        robot.keyPress(mod);
        robot.keyPress(67);
        robot.keyRelease(67);
        robot.keyRelease(mod);
        String text = Clipboard.getText();
        return text;
    }

    @Override
    public void copyRegion(ScreenRegion screenRegion) {
        DesktopMouse mouse = new DesktopMouse();
        ScreenLocation start = screenRegion.getUpperLeftCorner();
        ScreenLocation end = screenRegion.getLowerRightCorner();
        mouse.move(start);
        mouse.press();
        mouse.move(end);
        this.copy();
        mouse.release();
    }

    @Override
    public void paste(String text) {
        Preconditions.checkNotNull((Object)text);
        Clipboard.putText(Clipboard.PLAIN, Clipboard.UTF8, Clipboard.BYTE_BUFFER, text);
        int mod = Env.getHotkeyModifier();
        AWTRobot robot = DesktopKeyboard.getRobot();
        robot.keyPress(mod);
        robot.keyPress(86);
        robot.keyRelease(86);
        robot.keyRelease(mod);
    }

    @Override
    public void type(String text) {
        Preconditions.checkNotNull((Object)text);
        AWTRobot robot = DesktopKeyboard.getRobot();
        for (int i = 0; i < text.length(); ++i) {
            robot.pressModifiers(modifiers);
            robot.typeChar(text.charAt(i), AWTRobot.KeyMode.PRESS_RELEASE);
            robot.releaseModifiers(modifiers);
            robot.delay(20);
        }
        robot.waitForIdle();
    }

    @Override
    public void keyDown(int keycode) {
        DesktopKeyboard.getRobot().keyPress(keycode);
    }

    @Override
    public void keyUp(int keycode) {
        DesktopKeyboard.getRobot().keyRelease(keycode);
    }

    @Override
    public void keyDown(String keys) {
        if (keys != null) {
            for (int i = 0; i < keys.length(); ++i) {
                if (_hold_keys.indexOf(keys.charAt(i)) != -1) continue;
                DesktopKeyboard.getRobot().typeChar(keys.charAt(i), AWTRobot.KeyMode.PRESS_ONLY);
                _hold_keys = _hold_keys + keys.charAt(i);
            }
            DesktopKeyboard.getRobot().waitForIdle();
            return;
        }
    }

    @Override
    public void keyUp() {
        this.keyUp(null);
    }

    @Override
    public void keyUp(String keys) {
        if (keys == null) {
            keys = _hold_keys;
        }
        for (int i = 0; i < keys.length(); ++i) {
            int pos = _hold_keys.indexOf(keys.charAt(i));
            if (pos == -1) continue;
            DesktopKeyboard.getRobot().typeChar(keys.charAt(i), AWTRobot.KeyMode.RELEASE_ONLY);
            _hold_keys = _hold_keys.substring(0, pos) + _hold_keys.substring(pos + 1);
        }
        DesktopKeyboard.getRobot().waitForIdle();
    }

    static {
        _hold_keys = "";
    }
}

