/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import java.awt.Point;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.robot.desktop.AWTRobot;
import org.sikuli.api.robot.desktop.OutQuarticEase;
import org.sikuli.api.robot.desktop.TimeBasedAnimator;

class AWTMouse {
    AWTRobot robot;
    private static int _hold_buttons = 0;

    AWTMouse(AWTRobot robot) {
        this.robot = robot;
    }

    private void _move(int x, int y) {
        Point o = this.robot.getOrigin();
        int sx = x - o.x;
        int sy = y - o.y;
        this.robot.mouseMove(sx, sy);
        this.robot.waitForIdle();
    }

    public void smoothMove(ScreenLocation src, ScreenLocation dest, int ms) {
        if (ms == 0) {
            this._move(dest.getX(), dest.getY());
            return;
        }
        TimeBasedAnimator aniX = new TimeBasedAnimator(new OutQuarticEase(src.getX(), dest.getX(), ms));
        TimeBasedAnimator aniY = new TimeBasedAnimator(new OutQuarticEase(src.getY(), dest.getY(), ms));
        while (aniX.running()) {
            float x = aniX.step();
            float y = aniY.step();
            this._move((int)x, (int)y);
            this.robot.delay(50);
        }
    }

    private void _click(int buttons, int modifiers, boolean dblClick) {
        this.robot.pressModifiers(modifiers);
        this.robot.mousePress(buttons);
        this.robot.mouseRelease(buttons);
        if (dblClick) {
            this.robot.mousePress(buttons);
            this.robot.mouseRelease(buttons);
        }
        this.robot.releaseModifiers(modifiers);
        this.robot.waitForIdle();
    }

    public void move(ScreenLocation dest) {
        this._move(dest.getX(), dest.getY());
    }

    public void drag() {
        this.robot.mousePress(16);
        this.robot.waitForIdle();
    }

    public void drop() {
        int delay = 1;
        this.robot.delay(delay * 1000);
        this.robot.mouseRelease(16);
        this.robot.waitForIdle();
    }

    public void rightClick() {
        this._click(4, 0, false);
    }

    public void doubleClick() {
        this._click(16, 0, true);
    }

    public void click() {
        this._click(16, 0, false);
    }

    public void wheel(int direction, int steps) {
        for (int i = 0; i < steps; ++i) {
            this.robot.mouseWheel(direction);
            this.robot.delay(50);
        }
    }

    public void mouseDown(int buttons) {
        _hold_buttons = buttons;
        this.robot.mousePress(buttons);
        this.robot.waitForIdle();
    }

    public void mouseUp() {
        this.mouseUp(0);
    }

    public void mouseUp(int buttons) {
        if (buttons == 0) {
            this.robot.mouseRelease(_hold_buttons);
        } else {
            this.robot.mouseRelease(buttons);
        }
        this.robot.waitForIdle();
    }
}

