/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.event;

import org.sikuli.api.Relative;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.event.EventDetectionTask;
import org.sikuli.api.event.TargetEvent;
import org.sikuli.api.event.TargetEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TargetEventDetectionTask
implements EventDetectionTask {
    private static Logger logger = LoggerFactory.getLogger(TargetEventDetectionTask.class);
    private final ScreenRegion screenRegion;
    private final Target target;
    private final TargetEventListener listener;
    private ScreenRegion lastTargetRegion;

    public boolean equals(Object o) {
        TargetEventDetectionTask w = (TargetEventDetectionTask)o;
        return this.screenRegion == w.screenRegion && this.target == w.target && this.listener == w.listener;
    }

    public TargetEventDetectionTask(ScreenRegion screenRegion, Target target, TargetEventListener listener) {
        this.screenRegion = screenRegion;
        this.target = target;
        this.listener = listener;
        this.lastTargetRegion = null;
    }

    public void setLastTargetRegion(ScreenRegion lastTargetRegion) {
        this.lastTargetRegion = lastTargetRegion;
    }

    public TargetEvent createTargetEvent() {
        return new TargetEvent(this.target, this.screenRegion, this.lastTargetRegion);
    }

    @Override
    public void run() {
        ScreenRegion currentTargetRegion = null;
        if (this.lastTargetRegion == null) {
            currentTargetRegion = this.screenRegion.find(this.target);
            if (currentTargetRegion != null) {
                this.setLastTargetRegion(currentTargetRegion);
                this.listener.targetAppeared(this.createTargetEvent());
                logger.debug(this.target + " has appeared");
            }
        } else if (!TargetEventDetectionTask.isTargetVisibleAt(this.target, this.lastTargetRegion)) {
            currentTargetRegion = this.screenRegion.find(this.target);
            if (currentTargetRegion == null) {
                this.listener.targetVanished(this.createTargetEvent());
                this.setLastTargetRegion(null);
                logger.debug(this.target + " has vanished");
            } else {
                this.setLastTargetRegion(currentTargetRegion);
                this.listener.targetMoved(this.createTargetEvent());
                logger.debug(this.target + " has moved to " + currentTargetRegion);
            }
        }
    }

    private static boolean isTargetVisibleAt(Target target, ScreenRegion region) {
        if (region == null) {
            return false;
        }
        ScreenRegion neighborRegion = Relative.to(region).taller(2).wider(2).getScreenRegion();
        ScreenRegion newRegion = neighborRegion.find(target);
        if (newRegion == null) {
            logger.debug(target + " is not visible at " + newRegion);
            return false;
        }
        logger.debug(target + " is visible at " + newRegion);
        return true;
    }
}

