/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.base.Objects;
import java.awt.Rectangle;
import org.sikuli.api.DefaultScreenLocation;
import org.sikuli.api.DefaultScreenRegion;
import org.sikuli.api.Screen;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;

public abstract class AbstractScreenRegion
implements ScreenRegion {
    private int x;
    private int y;
    private int width;
    private int height;
    private double score;
    private Screen screen;

    public AbstractScreenRegion(Screen screen) {
        this.setX(0);
        this.setY(0);
        this.setWidth(screen.getSize().width);
        this.setHeight(screen.getSize().height);
        this.setScreen(screen);
    }

    public AbstractScreenRegion(Screen screen, int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.setScreen(screen);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public void setBounds(Rectangle newBounds) {
        this.setX(newBounds.x);
        this.setY(newBounds.y);
        this.setWidth(newBounds.width);
        this.setHeight(newBounds.height);
    }

    @Override
    public ScreenRegion getRelativeScreenRegion(int xoffset, int yoffset, int width, int height) {
        return new DefaultScreenRegion(this, xoffset, yoffset, width, height);
    }

    @Override
    public ScreenLocation getRelativeScreenLocation(int xoffset, int yoffset) {
        return new DefaultScreenLocation(this.screen, this.getX() + xoffset, this.getY() + yoffset);
    }

    @Override
    public ScreenLocation getCenter() {
        return this.getRelativeScreenLocation(this.getWidth() / 2, this.getHeight() / 2);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("screen", (Object)this.screen).add("x", this.x).add("y", this.y).add("width", this.width).add("height", this.height).add("score", this.score).toString();
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

