/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.util.Collection;
import java.util.TreeSet;
import org.shipkit.auto.version.ProcessRunner;
import org.shipkit.auto.version.VersionConfig;
import org.shipkit.auto.version.VersionNumber;

class VersionsProvider {
    private final ProcessRunner runner;

    VersionsProvider(ProcessRunner runner) {
        this.runner = runner;
    }

    Collection<VersionNumber> getAllVersions(String tagPrefix) {
        String gitOutput = this.runner.run("git", "tag");
        String[] tagOutput = gitOutput.split("\\R");
        TreeSet<VersionNumber> result = new TreeSet<VersionNumber>();
        for (String line : tagOutput) {
            String tag = line.trim();
            if (!VersionConfig.isSupportedVersion(tag, tagPrefix)) continue;
            String v = tag.substring(tagPrefix.length());
            result.add(new VersionNumber(v));
        }
        return result;
    }
}

