'use strict';

import './view-loader.scss';
import angular from 'angular';

export default angular.module('app.view-loader.directive', [])
    .directive('viewLoader', viewLoader);

viewLoader.$inject = ['$compile', 'semossCoreService'];

function viewLoader($compile: any, semossCoreService: SemossCoreService) {
    viewLoaderLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];
    return {
        restrict: 'E',
        require: ['^widget'],
        priority: 300,
        link: viewLoaderLink,
        template: require('./view-loader.directive.html')
    };

    function viewLoaderLink(scope: any, ele: any, attrs: any, ctrl: any) {
        let updateTaskListener: any,
            compiledEle: any;

        scope.widgetCtrl = ctrl[0];

        /**
         * @name paint
         * @desc paints the visualization
         */
        function paint(): void {
            let tasks = scope.widgetCtrl.getWidget('view.visualization.tasks'),
                html = tasks[0].data.values[0];
            if (compiledEle) {
                compiledEle.parentNode.removeChild(compiledEle);
                compiledEle = undefined;
            }

            if (html.indexOf('<img') > -1) {
                html = html.replace('<img', '<img style="width: 100%; height: 100%; object-fit: scale-down;"');
            }

            compiledEle = $compile('<div id="viewLoader" style="width: 100%; height: 100%">' + html + '</div>')(scope)[0];
            if (html && html.indexOf('<table') > -1) {
                compiledEle.firstElementChild.style.width = 'auto';
            }

            ele[0].firstElementChild.appendChild(compiledEle);
        }

        /**
         * @name initialize
         * @desc called when the directive is loaded
         */
        function initialize(): void {
            updateTaskListener = scope.widgetCtrl.on('update-task', paint);

            paint();
        }

        initialize();

        scope.$on('$destroy', function () {
            updateTaskListener();
        });
    }
}
