module.exports = {
    'name': 'Sunburst',
    'icon': require('images/sunburst-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'color-by-value',
            'color-panel-mode'
        ]
    },
    'content': {
        'template': {
            'name': 'sunburst-echarts'
        }
    },
    'visualization': {
        'type': [
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Sunburst',
        'visibleModes': [
            'default-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'display-values',
            'customize-sunburst-label',
            'sort-sunburst',
            'toggle-tooltips',
            'toggle-svg',
            'reset-state',
            'events',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'label',
                'name': 'Label',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': true,
                'description': 'Required:  Try adding one or several dimensions (i.e. Nominated and Movie Genre). Each dimension will represent a new ring of the sunburst.'
            },
            {
                'model': 'value',
                'name': 'Value',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': false,
                'multiField': false,
                'description': 'Required:  Try adding one numerical dimension (i.e. Count of Movie Title). This will represent the section size of its respectice instance.'
            }
        ],
        'color': {
            'label': {
                'multiField': true,
                'instances': true
            }
        }
    },
    'lazy': true
};
