'use strict';

import * as d3 from 'd3';
import '@/widget-resources/css/d3-charts.css';
import '@/widget-resources/js/jvCharts/src/jv.js';
import '@/widget-resources/js/jvCharts/src/jv.css';

export default angular.module('app.sankey-standard.directive', [])
    .directive('sankeyStandard', sankeyStandard);

sankeyStandard.$inject = ['VIZ_COLORS', 'semossCoreService'];


function sankeyStandard(VIZ_COLORS, semossCoreService) {
    sankeyStandardLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        restrict: 'EA',
        require: ['^widget'],
        link: sankeyStandardLink
    };

    function sankeyStandardLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];

        /** **************Get Chart Div *************************/
        scope.chartDiv = d3.select(ele[0].firstElementChild);
        /** ************* Main Event Listeners ************************/
        var resizeListener,
            updateTaskListener,
            updateOrnamentsListener,
            addDataListener,
            jvModeListener,
            /** *************** jvChart Object ****************************/
            jvChart,
            /** *************** local data Object ****************************/
            localChartData;

        /**
        * @name initialize
        * @desc creates the visualization on the chart div
        * @returns {void}
        */
        function initialize() {
            // bind listeners
            resizeListener = scope.widgetCtrl.on('resize-widget', resizeViz);
            updateTaskListener = scope.widgetCtrl.on('update-task', setData);
            updateOrnamentsListener = scope.widgetCtrl.on('update-ornaments', setData);
            addDataListener = scope.widgetCtrl.on('added-data', setData);
            jvModeListener = scope.widgetCtrl.on('update-mode', toggleMode);

            scope.$on('$destroy', destroy);

            setData();
        }

        /**
        * @name setData
        * @desc setData for the visualization and paints
        * @returns {void}
        */
        function setData() {
            var individiualTools = scope.widgetCtrl.getWidget('view.visualization.tools.individual.Sankey') || {},
                sharedTools = scope.widgetCtrl.getWidget('view.visualization.tools.shared'),
                keys = scope.widgetCtrl.getWidget('view.visualization.keys.Sankey'),
                layerIndex = 0,
                data = scope.widgetCtrl.getWidget('view.visualization.tasks.' + layerIndex + '.data');

            localChartData = {
                chartData: semossCoreService.visualization.getTableData(data.headers, data.values, data.rawHeaders),
                dataTableAlign: semossCoreService.visualization.getDataTableAlign(keys),
                callbacks: scope.widgetCtrl.getEventCallbacks(),
                uiOptions: angular.extend(sharedTools, individiualTools)
            };
            paint();
        }

        /**
        * @name paint
        * @desc paints the visualization
        * @returns {void}
        */
        function paint() {
            if (jvChart && typeof jvChart.destroy === 'function') {
                jvChart.destroy();
            }
            /** ********** Create and Paint JV Chart *************/
            jvChart = new jvCharts({
                type: 'sankey',
                options: localChartData.uiOptions,
                chartDiv: scope.chartDiv,
                callbacks: localChartData.callbacks,
                setData: {
                    data: localChartData.chartData.viewData,
                    dataTable: localChartData.dataTableAlign,
                    dataTableKeys: localChartData.chartData.dataTableKeys || [],
                    colors: VIZ_COLORS.COLOR_SEMOSS
                },
                comments: {},
                editOptions: {},
                mode: localChartData.uiOptions.mode || 'default-mode'
            });
        }

        /**
        * @name toggleMode
        * @desc switches the jv mode to the new specified mode
        * @returns {void}
        */
        function toggleMode() {
            jvChart.toggleModes(scope.widgetCtrl.getMode('selected'));
        }

        /**
        * @name resizeViz
        * @desc reruns the jv paint function
        * @returns {void}
        */
        function resizeViz() {
            jvChart.chartDiv = scope.chartDiv;
            // call paint with no transition
            jvChart.paint(0);
        }

        /**
        * @name destroy
        * @desc destroys listeners and dom elements outside of the scope
        * @returns {void}
        */
        function destroy() {
            resizeListener();
            updateTaskListener();
            updateOrnamentsListener();
            addDataListener();
            jvModeListener();
        }

        /** ********* Start Visualization Creation ***************/
        initialize();
    }
}
