module.exports = {
    'name': 'Sankey',
    'icon': require('images/sankey-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'sankey-standard',
            'files': [
                'widget-resources/js/d3-sankey/d3-sankey.js'
            ]
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Sankey',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'sort-values',
            'color-by-value',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'label',
                'name': 'Label',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'optional': false,
                'multiField': true,
                'description': 'Try adding two or more dimensions (i.e. Nominated and Movie Genre). The dimensions are linked to show their connection and flow.'
            },
            {
                'model': 'value',
                'name': 'Value',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'optional': false,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. Movie Budget). The value of this dimension represents the size of its respective link between nodes.'
            }
        ],
        'color': {}
    },
    'lazy': true
};
