'use strict';

/**
 * @name refresh-cache.directive.js
 * @desc delete cache and refresh recipe
 */
export default angular.module('app.refresh-cache.directive', [])
    .directive('refreshCache', refreshCacheDirective);

refreshCacheDirective.$inject = [];

function refreshCacheDirective() {
    refreshCacheLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        restrict: 'E',
        require: ['^widget'],
        link: refreshCacheLink,
        scope: {}
    };

    function refreshCacheLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];

        /**
         * @name initialize
         * @returns {void}
         */
        function initialize() {
            var appId,
                appInsightId,
                steps,
                pixelComponents = [],
                stepIdx;

            appId = scope.widgetCtrl.getShared('insight.app_id');
            appInsightId = scope.widgetCtrl.getShared('insight.app_insight_id');
            steps = scope.widgetCtrl.getShared('steps');

            // refresh the recipe
            pixelComponents.push({
                type: 'clearInsight',
                components: [],
                meta: true,
                terminal: true
            });

            for (stepIdx = 0; stepIdx < steps.length; stepIdx++) {
                pixelComponents.push({
                    type: 'Pixel',
                    components: [steps[stepIdx].expression],
                    terminal: true
                });
            }

            if (appId && appInsightId) {
                scope.widgetCtrl.query([{
                    type: 'deleteInsightCache',
                    components: [appId, appInsightId],
                    terminal: true
                }]);
            }

            scope.widgetCtrl.emit('execute-pixel', {
                insightID: scope.widgetCtrl.insightID,
                commandList: pixelComponents,
                direction: 'backward'
            });
        }

        initialize();
    }
}
