'use strict';

import './purge.scss';

/**
 * @name purge
 * @desc Sort Values directive used to sort the directive
 */
export default angular.module('app.purge.directive', [])
    .directive('purge', purgeDirective);

purgeDirective.$inject = [];

function purgeDirective() {
    purgeCtrl.$inject = [];
    purgeLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        scope: {},
        restrict: 'EA',
        require: ['^widget'],
        controllerAs: 'purge',
        bindToController: {},
        template: require('./purge.directive.html'),
        controller: purgeCtrl,
        link: purgeLink
    };

    function purgeCtrl() {}

    function purgeLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];

        scope.purge.execute = execute;

        /**
         * @name execute
         * @desc execute the purge query to purge the filtered values
         * @returns {void}
         */
        function execute() {
            scope.widgetCtrl.execute([{
                type: 'variable',
                components: [
                    scope.widgetCtrl.getFrame('name')
                ]
            }, {
                type: 'purge',
                components: [],
                terminal: true
            }]);
        }

        /**
         * @name getFilteredValues
         * @desc makes the BE call to get the filter model
         * @returns {object} all of the filtered values
         */
        function getFilteredValues() {
            var callback = function (response) {
                var output = response.pixelReturn[0].output,
                    i, j;

                for (i = 0; i < output.length; i++) {
                    if (output[i].filterObj.filterType === 'SIMPLE') {
                        output[i].filterObj.right.display = '';

                        if (Array.isArray(output[i].filterObj.left.value)) {
                            output[i].filterObj.left.display = output[i].filterObj.left.value.join(', ');
                        } else {
                            output[i].filterObj.left.display = String(output[i].filterObj.left.value);
                        }

                        output[i].filterObj.left.display = output[i].filterObj.left.display.replace(/_/g, ' ');

                        if (Array.isArray(output[i].filterObj.right.value)) {
                            for (j = 0; j < output[i].filterObj.right.value.length; j++) {
                                output[i].filterObj.right.display += output[i].filterObj.right.value[j] || output[i].filterObj.right.value[j] === 0 ? output[i].filterObj.right.value[j] : 'null';
                                if (output[i].filterObj.right.value.length - 1 !== j) {
                                    output[i].filterObj.right.display += ', ';
                                }
                            }
                        } else {
                            output[i].filterObj.right.display = output[i].filterObj.right.value || output[i].filterObj.right.value === 0 ? String(output[i].filterObj.right.value) : 'null';
                        }

                        output[i].filterObj.right.display = output[i].filterObj.right.display.replace(/_/g, ' ');
                    } else {
                        output[i].filterStrDisplay = output[i].filterStr.replace(/_/g, ' ');
                    }

                    if (output[i].filterObj.comparator === '==') {
                        output[i].filterObj.comparator = 'Equals';
                    } else if (output[i].filterObj.comparator === '!=') {
                        output[i].filterObj.comparator = 'Not Equals';
                    } else if (output[i].filterObj.comparator === '?like') {
                        output[i].filterObj.comparator = '?like';
                    }
                }
                // set
                scope.purge.frameFilters = output;
            };

            scope.widgetCtrl.meta(
                [
                    {
                        type: 'variable',
                        components: [
                            scope.widgetCtrl.getFrame('name')
                        ]
                    },
                    {
                        type: 'getFrameFilters',
                        components: [],
                        terminal: true
                    }
                ],
                callback);
        }

        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            var updateFrameListener = scope.widgetCtrl.on('update-frame', getFilteredValues);

            // cleanup
            scope.$on('$destroy', function () {
                updateFrameListener();
            });

            getFilteredValues();
        }

        initialize();
    }
}
